/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IAttackTargetChanger;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IMobEntityChanger;
import de.cech12.usefulhats.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1590;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class HaloItem
extends AbstractHatItem
implements IAttackTargetChanger,
IMobEntityChanger,
IEquipmentChangeListener {
    private static final Map<class_1309, Integer> PREVIOUS_DAMAGE_TICK_OF_ENTITY = new HashMap<class_1309, Integer>();

    public HaloItem(String name) {
        super(name, HatArmorMaterials.HALO, Services.CONFIG::getHaloDurability, Services.CONFIG::isHaloDamageEnabled);
    }

    @Override
    public void method_67187(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull class_10712 display, @NotNull Consumer<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_67187(stack, context, display, tooltip, flagIn);
        tooltip.accept((class_2561)class_2561.method_43471((String)"item.usefulhats.halo.desc.no_attack").method_27692(class_124.field_1078));
        tooltip.accept((class_2561)class_2561.method_43471((String)"item.usefulhats.halo.desc.beware_of_nether").method_27692(class_124.field_1061));
    }

    private static boolean isNether(class_1937 level) {
        return level.method_8597().comp_644() && level.method_8597().method_44220();
    }

    @Override
    public void onEntityJoinWorldEvent(class_1309 entity) {
        if (entity instanceof class_1590) {
            class_1590 zombifiedPiglin = (class_1590)entity;
            Services.REGISTRY.addGoalToMob((class_1308)zombifiedPiglin, 1, (class_1352)new NearestHaloTargetGoal((class_1308)zombifiedPiglin, this));
        }
    }

    @Override
    public boolean avoidMobChangingTarget(class_1799 stack, class_1309 entity, class_1309 target) {
        Integer previousDamageTick;
        if (Services.REGISTRY.isBossEntity(entity) || HaloItem.isNether(target.method_37908())) {
            return false;
        }
        if (((Boolean)this.enabledDamageConfig.get()).booleanValue() && ((previousDamageTick = PREVIOUS_DAMAGE_TICK_OF_ENTITY.get(target)) == null || previousDamageTick + 20 <= target.field_6012)) {
            this.damageHatItemByOne(stack, target);
            PREVIOUS_DAMAGE_TICK_OF_ENTITY.put(target, target.field_6012);
        }
        return true;
    }

    @Override
    public void onEquippedHatItem(class_1309 entity, class_1799 newStack) {
        if (HaloItem.isNether(entity.method_37908())) {
            return;
        }
        class_243 entityPos = entity.method_19538();
        int range = 32;
        class_238 radius = new class_238(entityPos.method_10216() - (double)range, entityPos.method_10214() - (double)range, entityPos.method_10215() - (double)range, entityPos.method_10216() + (double)range, entityPos.method_10214() + (double)range, entityPos.method_10215() + (double)range);
        entity.method_37908().method_8390(class_1308.class, radius, mob -> mob.method_5968() == entity && !Services.REGISTRY.isBossEntity((class_1309)mob)).forEach(mob -> mob.method_5980(null));
    }

    private static class NearestHaloTargetGoal
    extends class_1400<class_1309> {
        NearestHaloTargetGoal(class_1308 mobEntity, IMobEntityChanger hatItem) {
            super(mobEntity, class_1309.class, 0, true, false, (entity, level) -> {
                if (HaloItem.isNether((class_1937)level)) {
                    for (class_1799 headSlotItemStack : Services.REGISTRY.getEquippedHatItemStacks(entity)) {
                        if (headSlotItemStack.method_7909() != hatItem) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }
}

