/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractMiningHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class MiningHatItem
extends AbstractMiningHatItem
implements IEquipmentChangeListener {
    private static final int NIGHT_VISION_DURATION = 239;
    private static final int NIGHT_VISION_AMPLIFIER = 0;

    public MiningHatItem(String name) {
        super(name, HatArmorMaterials.MINING, Services.CONFIG::getMiningHatDurability, Services.CONFIG::isMiningHatDamageEnabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLightEnabled(class_1309 entity) {
        if (!Services.CONFIG.isMiningHatNightVisionEnabled()) return false;
        if (!Services.REGISTRY.getEquippedHatItemStacks(entity).stream().anyMatch(stack -> stack.method_7909() instanceof MiningHatItem)) return false;
        if (!Arrays.stream(class_1268.values()).map(arg_0 -> ((class_1309)entity).method_5998(arg_0)).anyMatch(Services.REGISTRY::isAxe)) return false;
        if (entity.method_6112(class_1294.field_5925) != null) return false;
        if (entity.method_37908().method_22339(entity.method_24515()) >= 8) return false;
        return true;
    }

    @Override
    protected double getSpeedConfig(int enchantmentLevel) {
        return Services.CONFIG.getMiningHatSpeedWithEfficiency(enchantmentLevel);
    }

    @Override
    public void method_67187(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull class_10712 display, @NotNull Consumer<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_67187(stack, context, display, tooltip, flagIn);
        int value = (int)(this.getEnchantmentDoubleValue(stack) * 100.0);
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.usefulhats.mining_hat.desc.mining_speed", (Object[])new Object[]{value}).method_27692(class_124.field_1078));
        if (Services.CONFIG.isMiningHatNightVisionEnabled()) {
            if (Services.PLATFORM.isModLoaded("lucent")) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"item.usefulhats.mining_hat.desc.lucent").method_27692(class_124.field_1078));
            } else {
                tooltip.accept((class_2561)class_2561.method_43471((String)"item.usefulhats.mining_hat.desc.night_vision").method_27692(class_124.field_1078));
            }
        }
    }

    public void method_7888(@NotNull class_1799 stack, class_3218 level, @NotNull class_1297 entity, class_1304 slot) {
        if (!level.field_9236 && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            if (!Services.CONFIG.isMiningHatNightVisionEnabled()) {
                return;
            }
            if (Services.PLATFORM.isModLoaded("lucent")) {
                if (MiningHatItem.isLightEnabled(livingEntity) && livingEntity.field_6012 % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
                return;
            }
            if (this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5925, 239, 0)) {
                return;
            }
            if (Arrays.stream(class_1268.values()).map(arg_0 -> ((class_1309)livingEntity).method_5998(arg_0)).anyMatch(Services.REGISTRY::isPickaxe) && livingEntity.method_37908().method_22339(livingEntity.method_24515()) < 8) {
                if (livingEntity.method_6112(class_1294.field_5925) == null || livingEntity.field_6012 % 19 == 0) {
                    this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5925, 239, 0);
                }
                if (livingEntity.field_6012 % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
            } else {
                livingEntity.method_6016(class_1294.field_5925);
            }
        }
    }

    @Override
    protected boolean isToolEffective(class_1799 tool, class_2680 state) {
        return Services.REGISTRY.isPickaxe(tool) && state.method_26164(class_3481.field_33715);
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5925, 239, 0);
    }
}

