/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.vanala.lostrealms.Config;
import net.vanala.lostrealms.block.custom.ModBlocks;
import net.vanala.lostrealms.entity.ModEntities;
import net.vanala.lostrealms.entity.client.KomodoDragonRenderer;
import net.vanala.lostrealms.entity.client.LeopardRenderer;
import net.vanala.lostrealms.item.ModCreativeModeTabs;
import net.vanala.lostrealms.item.ModItems;
import org.slf4j.Logger;

@Mod(value="lostrealms")
public class LostRealms {
    public static final String MOD_ID = "lostrealms";
    public static final Logger LOGGER = LogUtils.getLogger();

    public LostRealms(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ModItems.FOSSIL_SHARD);
            event.accept(ModItems.FOSSIL_DUST);
            event.accept(ModItems.FOSSIL_FUEL);
            event.accept(ModItems.STEEL_INGOT);
            event.accept(ModItems.OXYGENATED_IRON_INGOT);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.ANCIENT_TOTEM);
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept(ModBlocks.STEEL_BLOCK);
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept(ModBlocks.FOSSIL_BLOCK);
        }
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept(ModItems.LEOPARD_SPAWN_EGG);
            event.accept(ModItems.KOMODO_DRAGON_SPAWN_EGG);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="lostrealms", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static class ClientModEvents {
        ClientModEvents() {
        }

        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.LEOPARD.get(), LeopardRenderer::new);
            EntityRenderers.register(ModEntities.KOMODO_DRAGON.get(), KomodoDragonRenderer::new);
        }
    }
}

