/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.vanala.lostrealms.block.custom.ModBlocks;
import net.vanala.lostrealms.item.ModItems;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        List<DeferredBlock<Block>> FOSSIL_SMELTABLES = List.of(ModItems.FOSSIL_SHARD, ModBlocks.FOSSIL_BLOCK);
        List<DeferredItem<Item>> FUEL_SMELTABLE = List.of(ModItems.FOSSIL_DUST);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FOSSIL_BLOCK.get())).pattern("SSS").pattern("SFS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Items.STONE.asItem()).define(Character.valueOf('F'), (ItemLike)ModItems.FOSSIL_SHARD.get()).unlockedBy("has_fossil_shard", ModRecipeProvider.has(ModItems.FOSSIL_SHARD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.STEEL_BLOCK.get())).pattern("SSS").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ModItems.STEEL_INGOT.get()).unlockedBy("has_steel_ingot", ModRecipeProvider.has(ModItems.STEEL_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)9).requires(ModBlocks.STEEL_BLOCK).unlockedBy("has_steel_block", ModRecipeProvider.has(ModBlocks.STEEL_BLOCK)).save(recipeOutput);
        ModRecipeProvider.oreSmelting(recipeOutput, FOSSIL_SMELTABLES, RecipeCategory.MISC, ModItems.FOSSIL_DUST, 0.25f, 200, "fossil");
        ModRecipeProvider.oreSmelting(recipeOutput, FUEL_SMELTABLE, RecipeCategory.MISC, ModItems.FOSSIL_FUEL, 0.5f, 2000, "fossil");
        ModRecipeProvider.oreBlasting(recipeOutput, FOSSIL_SMELTABLES, RecipeCategory.MISC, ModItems.FOSSIL_DUST, 0.25f, 100, "fossil");
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "lostrealms:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

