/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.vanala.lostrealms.entity.client.KomodoDragonAnimations;
import net.vanala.lostrealms.entity.custom.KomodoDragonEntity;

public class KomodoDragonModel<T extends KomodoDragonEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"lostrealms", (String)"komodo_dragon"), "main");
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;

    public KomodoDragonModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Neck = this.Body.getChild("Neck");
        this.Head = this.Neck.getChild("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -4.0f, -11.0f, 9.0f, 7.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)-1.0f));
        PartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(0, 49).addBox(-2.0f, -3.0f, -6.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-1.0f, (float)-10.0f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(20, 49).addBox(-2.0f, 1.0f, -4.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 47).addBox(-2.0f, -3.0f, -10.0f, 5.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(0, 61).addBox(-2.0f, 0.0f, -7.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-3.0f));
        PartDefinition bone = Jaw.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(20, 55).addBox(0.0f, 0.0f, -3.0f, 1.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(64, 25).addBox(-1.0f, 0.0f, -5.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.075f, (float)-2.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-1.5f, (float)11.0f));
        PartDefinition cube_r1 = Tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -3.0f, -12.0f, 6.0f, 6.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)2.2f, (float)12.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition bone4 = Tail.addOrReplaceChild("bone4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)13.0f));
        PartDefinition cube_r2 = bone4.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(38, 30).addBox(-1.0f, -3.0f, -12.0f, 3.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)11.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLegs = Body.addOrReplaceChild("FrontLegs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        PartDefinition FrontLeftLeg = FrontLegs.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(64, 12).addBox(0.5f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 61).addBox(-0.5f, 8.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-8.0f, (float)-8.0f));
        PartDefinition FrontRightLeg = FrontLegs.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(54, 67).addBox(-4.5f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(64, 6).addBox(-5.5f, 8.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-8.0f, (float)-8.0f));
        PartDefinition BackLegs = Body.addOrReplaceChild("BackLegs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        PartDefinition BackLeftLeg = BackLegs.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(22, 67).addBox(0.5f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(46, 61).addBox(-0.5f, 8.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-8.0f, (float)6.0f));
        PartDefinition BackRightLeg = BackLegs.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(38, 67).addBox(-4.5f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(64, 0).addBox(-5.5f, 8.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-8.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(KomodoDragonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(KomodoDragonAnimations.KOMODO_DRAGON_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, KomodoDragonAnimations.KOMODO_DRAGON_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.Head.yRot = headYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.Body;
    }
}

