/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.vanala.lostrealms.entity.client.LeopardAnimations;
import net.vanala.lostrealms.entity.custom.LeopardEntity;

public class LeopardModel<T extends LeopardEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"lostrealms", (String)"leopard"), "main");
    private final ModelPart Body;
    private final ModelPart Head;

    public LeopardModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -10.0f, 7.0f, 8.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-3.5f, 5.0f, -10.0f, 7.0f, 1.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)-1.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)-1.5f, (float)9.2f));
        PartDefinition Tail_r1 = Tail.addOrReplaceChild("Tail_r1", CubeListBuilder.create().texOffs(0, 49).addBox(-2.0f, -1.0f, -11.0f, 3.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)7.8f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Tail1 = Tail.addOrReplaceChild("Tail1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)7.0f));
        PartDefinition Tail1_r1 = Tail1.addOrReplaceChild("Tail1_r1", CubeListBuilder.create().texOffs(26, 49).addBox(-1.99f, -0.97f, -11.11f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.005f, (float)0.339f, (float)9.445f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.addOrReplaceChild("Tail2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)8.0f));
        PartDefinition Tail2_r1 = Tail2.addOrReplaceChild("Tail2_r1", CubeListBuilder.create().texOffs(50, 49).addBox(-2.0304f, -1.0912f, -10.6656f, 3.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0152f, (float)-5.5595f, (float)6.9758f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)-1.0f, (float)-9.0f));
        PartDefinition cube_r1 = Neck.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(54, 37).addBox(-0.5f, 2.0f, 4.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(54, 11).addBox(-3.0f, -4.0f, 4.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-8.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(54, 0).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(54, 44).addBox(-2.0f, 0.0f, -7.5f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-11.0f));
        PartDefinition cube_r2 = Head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(64, 37).addBox(-3.0f, 2.0f, 7.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.3f, (float)-7.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition cube_r3 = Head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(40, 62).addBox(2.0f, 2.0f, 7.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3f, (float)-7.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(14, 63).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-5.0f));
        PartDefinition LeftFrontLeg = Body.addOrReplaceChild("LeftFrontLeg", CubeListBuilder.create().texOffs(26, 62).addBox(-0.7f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)4.0f, (float)-6.0f));
        PartDefinition RightFrontLeg = Body.addOrReplaceChild("RightFrontLeg", CubeListBuilder.create().texOffs(0, 63).addBox(-2.3f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)4.0f, (float)-6.0f));
        PartDefinition LeftBackLeg = Body.addOrReplaceChild("LeftBackLeg", CubeListBuilder.create().texOffs(54, 22).addBox(-0.5f, -1.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)2.0f, (float)6.0f));
        PartDefinition RightBackLeg = Body.addOrReplaceChild("RightBackLeg", CubeListBuilder.create().texOffs(50, 61).addBox(-2.5f, -1.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)2.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LeopardEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(LeopardAnimations.LEOPARD_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, LeopardAnimations.LEOPARD_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.Head.yRot = headYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.Body;
    }
}

