/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms.event;

import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.vanala.lostrealms.entity.ModEntities;
import net.vanala.lostrealms.entity.client.KomodoDragonModel;
import net.vanala.lostrealms.entity.client.LeopardModel;
import net.vanala.lostrealms.entity.custom.KomodoDragonEntity;
import net.vanala.lostrealms.entity.custom.LeopardEntity;

@EventBusSubscriber(modid="lostrealms", bus=EventBusSubscriber.Bus.MOD)
public class ModEventBusEvents {
    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LeopardModel.LAYER_LOCATION, LeopardModel::createBodyLayer);
        event.registerLayerDefinition(KomodoDragonModel.LAYER_LOCATION, KomodoDragonModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.LEOPARD.get(), LeopardEntity.createAttributes().build());
        event.put(ModEntities.KOMODO_DRAGON.get(), KomodoDragonEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(ModEntities.LEOPARD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LeopardEntity::checkLeopardSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.KOMODO_DRAGON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }
}

