/*
 * Decompiled with CFR 0.152.
 */
package net.vanala.lostrealms.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.vanala.lostrealms.entity.ModEntities;
import net.vanala.lostrealms.worldgen.ModPlacedFeatures;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_FOSSIL_BLOCK = ModBiomeModifiers.registerKey("add_fossil_block");
    public static final ResourceKey<BiomeModifier> SPAWN_LEOPARD = ModBiomeModifiers.registerKey("spawn_leopard");
    public static final ResourceKey<BiomeModifier> SPAWN_KOMODO_DRAGON = ModBiomeModifiers.registerKey("spawn_komodo_dragon");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_FOSSIL_BLOCK, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.FOSSIL_BLOCK_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SPAWN_LEOPARD, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SNOWY_SLOPES), biomes.getOrThrow(Biomes.SNOWY_PLAINS)}), List.of(new MobSpawnSettings.SpawnerData(ModEntities.LEOPARD.get(), 15, 1, 3))));
        context.register(SPAWN_KOMODO_DRAGON, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SAVANNA), biomes.getOrThrow(Biomes.JUNGLE)}), List.of(new MobSpawnSettings.SpawnerData(ModEntities.KOMODO_DRAGON.get(), 15, 1, 2))));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lostrealms", (String)name));
    }
}

