/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.clicklisteners.CycleClick;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.util.Util;
import world.bentobox.level.Level;
import world.bentobox.warps.commands.ToggleWarpCommand;
import world.bentobox.warps.commands.WarpCommand;
import world.bentobox.warps.commands.WarpsCommand;
import world.bentobox.warps.config.Settings;
import world.bentobox.warps.listeners.WarpSignsListener;
import world.bentobox.warps.managers.SignCacheManager;
import world.bentobox.warps.managers.WarpSignsManager;

public class Warp
extends Addon {
    private static final String LEVEL_ADDON_NAME = "Level";
    public static final String WELCOME_WARP_SIGNS = "welcomewarpsigns";
    private WarpSignsManager warpSignsManager;
    private SignCacheManager signCacheManager;
    private Set<World> registeredWorlds;
    private Settings settings;
    private boolean hooked;
    private Config<Settings> settingsConfig;
    private Flag createWarpFlag;

    public void onLoad() {
        super.onLoad();
        this.saveDefaultConfig();
        if (this.loadSettings() && this.getSettings().isAllowInOtherWorlds()) {
            new WarpCommand(this);
            new WarpsCommand(this);
            new ToggleWarpCommand(this);
        }
    }

    public void onReload() {
        super.onReload();
        if (this.hooked || this.getSettings().isAllowInOtherWorlds()) {
            this.warpSignsManager.saveWarpList();
            this.loadSettings();
            this.getLogger().info("Warps addon reloaded.");
        }
    }

    public void onEnable() {
        if (!this.getPlugin().isEnabled()) {
            this.setState(Addon.State.DISABLED);
            return;
        }
        this.registeredWorlds = new HashSet<World>();
        this.getPlugin().getAddonsManager().getGameModeAddons().forEach(gameModeAddon -> {
            if (!this.settings.getDisabledGameModes().contains(gameModeAddon.getDescription().getName()) && gameModeAddon.getPlayerCommand().isPresent()) {
                this.registeredWorlds.add(gameModeAddon.getOverWorld());
                new WarpCommand(this, (CompositeCommand)gameModeAddon.getPlayerCommand().get());
                new WarpsCommand(this, (CompositeCommand)gameModeAddon.getPlayerCommand().get());
                new ToggleWarpCommand(this, (CompositeCommand)gameModeAddon.getPlayerCommand().get());
                this.hooked = true;
            }
        });
        if (this.hooked || this.getSettings().isAllowInOtherWorlds()) {
            this.warpSignsManager = new WarpSignsManager(this, this.getPlugin());
            this.signCacheManager = new SignCacheManager(this);
            this.registerListener(new WarpSignsListener(this));
        } else {
            this.logWarning("Addon did not hook into anything and is not running stand-alone");
            this.setState(Addon.State.DISABLED);
        }
        this.createWarpFlag = new Flag.Builder("PLACE_WARP", Material.OAK_SIGN).addon((Addon)this).defaultRank(500).clickHandler((PanelItem.ClickHandler)new CycleClick("PLACE_WARP", 500, 1000)).defaultSetting(false).mode(Flag.Mode.EXPERT).build();
        this.getPlugin().getFlagsManager().registerFlag((Addon)this, this.createWarpFlag);
    }

    public void onDisable() {
        if (this.warpSignsManager != null) {
            this.warpSignsManager.saveWarpList();
        }
    }

    private boolean loadSettings() {
        if (this.settingsConfig == null) {
            this.settingsConfig = new Config((Addon)this, Settings.class);
        }
        this.settings = (Settings)this.settingsConfig.loadConfigObject();
        if (this.settings == null) {
            this.logError("WelcomeWarp settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return false;
        }
        this.saveResource("panels/warps_panel.yml", false);
        this.settingsConfig.saveConfigObject((Object)this.settings);
        return true;
    }

    public SignCacheManager getSignCacheManager() {
        return this.signCacheManager;
    }

    public WarpSignsManager getWarpSignsManager() {
        return this.warpSignsManager;
    }

    public String getPermPrefix(World world) {
        return this.getPlugin().getIWM().getPermissionPrefix(world);
    }

    public boolean inRegisteredWorld(World world) {
        return this.registeredWorlds.contains(Util.getWorld((World)world));
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Flag getCreateWarpFlag() {
        return this.createWarpFlag;
    }

    public Long getLevel(World world, UUID uniqueId) {
        String name = this.getPlugin().getIWM().getAddon(world).map(g -> g.getDescription().getName()).orElse("");
        return this.getPlugin().getAddonsManager().getAddonByName(LEVEL_ADDON_NAME).map(l -> {
            Level addon = (Level)l;
            if (!name.isEmpty() && !addon.getSettings().getGameModes().contains(name)) {
                return addon.getIslandLevel(world, uniqueId);
            }
            return null;
        }).orElse(null);
    }

    public Object request(String requestLabel, Map<String, Object> metaData) {
        if (metaData.isEmpty()) {
            return null;
        }
        World world = null;
        UUID uuid = null;
        if (metaData.containsKey("world")) {
            world = Bukkit.getWorld((String)((String)metaData.get("world")));
        }
        if (world == null) {
            return null;
        }
        if (metaData.containsKey("uuid")) {
            try {
                uuid = UUID.fromString((String)metaData.get("uuid"));
            }
            catch (Exception e) {
                this.logError("Requested UUID is invalid");
                return null;
            }
        }
        return switch (requestLabel) {
            case "getSortedWarps" -> this.getWarpSignsManager().getSortedWarps(world);
            case "getWarp" -> {
                if (uuid == null) {
                    yield null;
                }
                yield this.getWarpSignsManager().getWarpLocation(world, uuid);
            }
            case "getWarpMap" -> this.getWarpSignsManager().getWarpMap(world);
            case "hasWarp" -> {
                if (uuid == null) {
                    yield null;
                }
                yield Boolean.valueOf(this.getWarpSignsManager().hasWarp(world, uuid));
            }
            case "listWarps" -> this.getWarpSignsManager().listWarps(world);
            default -> null;
        };
    }
}

