/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.commands;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.warps.Warp;
import world.bentobox.warps.event.WarpToggleEvent;
import world.bentobox.warps.objects.PlayerWarp;

public class ToggleWarpCommand
extends CompositeCommand {
    private final Warp addon;

    public ToggleWarpCommand(Warp addon, CompositeCommand bsbIslandCmd) {
        super(bsbIslandCmd, addon.getSettings().getToggleWarpCommand(), new String[0]);
        this.addon = addon;
    }

    public ToggleWarpCommand(Warp addon) {
        super(addon.getSettings().getToggleWarpCommand(), new String[0]);
        this.addon = addon;
    }

    public void setup() {
        this.setPermission(this.getParent() == null ? "welcomewarpsigns.togglewarp" : "island.warp.toggle");
        this.setOnlyPlayer(true);
        this.setDescription("togglewarp.help.description");
    }

    public boolean execute(User user, String s, List<String> list) {
        UUID userUUID = user.getUniqueId();
        World userWorld = user.getWorld();
        boolean hasWarp = this.addon.getWarpSignsManager().hasWarp(userWorld, userUUID);
        if (hasWarp) {
            PlayerWarp warp = this.addon.getWarpSignsManager().getPlayerWarp(userWorld, userUUID);
            if (warp == null) {
                user.sendMessage("togglewarp.error.generic", new String[0]);
                return false;
            }
            warp.toggle();
            Bukkit.getPluginManager().callEvent((Event)new WarpToggleEvent(userUUID, warp));
            String message = warp.isEnabled() ? "togglewarp.enabled" : "togglewarp.disabled";
            user.sendMessage(message, new String[0]);
        } else {
            user.sendMessage("togglewarp.error.no-warp", new String[0]);
        }
        return false;
    }
}

