/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.commands;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.World;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.DelayedTeleportCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.warps.Warp;

public class WarpCommand
extends DelayedTeleportCommand {
    private final Warp addon;

    public WarpCommand(Warp addon, CompositeCommand bsbIslandCmd) {
        super(bsbIslandCmd, addon.getSettings().getWarpCommand(), new String[0]);
        this.addon = addon;
    }

    public WarpCommand(Warp addon) {
        super((Addon)addon, addon.getSettings().getWarpCommand(), new String[0]);
        this.addon = addon;
    }

    public void setup() {
        this.setPermission(this.getParent() == null ? "welcomewarpsigns.warp" : "island.warp");
        this.setOnlyPlayer(true);
        this.setParametersHelp("warp.help.parameters");
        this.setDescription("warp.help.description");
    }

    public boolean execute(User user, String label, List<String> args) {
        if (args.size() == 1) {
            World world = this.getWorld() == null ? user.getWorld() : this.getWorld();
            Set<UUID> warpList = this.addon.getWarpSignsManager().listWarps(world);
            if (warpList.isEmpty()) {
                user.sendMessage("warps.error.no-warps-yet", new String[0]);
                user.sendMessage("warps.warpTip", new String[]{"[text]", this.addon.getSettings().getWelcomeLine()});
                return false;
            }
            UUID foundWarp = warpList.stream().filter(u -> this.getPlayers().getName(u).equalsIgnoreCase((String)args.get(0))).findFirst().orElse(null);
            if (foundWarp == null) {
                UUID foundAlernativeWarp = warpList.stream().filter(u -> this.getPlayers().getName(u).toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).findFirst().orElse(null);
                if (foundAlernativeWarp == null) {
                    user.sendMessage("warps.error.does-not-exist", new String[0]);
                    return false;
                }
                this.delayCommand(user, () -> this.addon.getWarpSignsManager().warpPlayer(world, user, foundAlernativeWarp));
                return true;
            }
            this.delayCommand(user, () -> this.addon.getWarpSignsManager().warpPlayer(world, user, foundWarp));
            return true;
        }
        this.showHelp((CompositeCommand)this, user);
        return false;
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        World world = this.getWorld() == null ? user.getWorld() : this.getWorld();
        return Optional.of(this.addon.getWarpSignsManager().listWarps(world).stream().map(arg_0 -> ((PlayersManager)this.getPlayers()).getName(arg_0)).toList());
    }
}

