/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.listeners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.addon.AddonEvent;
import world.bentobox.bentobox.api.events.flags.FlagProtectionChangeEvent;
import world.bentobox.bentobox.api.events.team.TeamKickEvent;
import world.bentobox.bentobox.api.events.team.TeamLeaveEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.warps.Warp;
import world.bentobox.warps.event.WarpRemoveEvent;
import world.bentobox.warps.objects.PlayerWarp;

public class WarpSignsListener
implements Listener {
    private static final String WARPS_DEACTIVATE = "warps.deactivate";
    private final BentoBox plugin;
    private final Warp addon;

    public WarpSignsListener(Warp addon) {
        this.addon = addon;
        this.plugin = addon.getPlugin();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChunkLoad(final ChunkLoadEvent event) {
        new BukkitRunnable(){

            public void run() {
                boolean changed = false;
                Iterator<Map.Entry<UUID, PlayerWarp>> iterator = WarpSignsListener.this.addon.getWarpSignsManager().getWarpMap(event.getWorld()).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, PlayerWarp> entry = iterator.next();
                    UUID uuid = entry.getKey();
                    Location location = entry.getValue().getLocation();
                    if (event.getChunk().getX() != location.getBlockX() >> 4 || event.getChunk().getZ() != location.getBlockZ() >> 4 || Tag.SIGNS.isTagged((Keyed)location.getBlock().getType())) continue;
                    iterator.remove();
                    WarpSignsListener.this.addon.getSignCacheManager().removeWarp(event.getWorld(), uuid);
                    changed = true;
                }
                if (changed) {
                    WarpSignsListener.this.addon.getWarpSignsManager().saveWarpList();
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerLeave(TeamLeaveEvent e) {
        this.addon.getWarpSignsManager().removeWarp(e.getIsland().getWorld(), e.getPlayerUUID());
        Objects.requireNonNull(User.getInstance((UUID)e.getPlayerUUID())).sendMessage(WARPS_DEACTIVATE, new String[0]);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerLeave(TeamKickEvent e) {
        this.addon.getWarpSignsManager().removeWarp(e.getIsland().getWorld(), e.getPlayerUUID());
        Objects.requireNonNull(User.getInstance((UUID)e.getPlayerUUID())).sendMessage(WARPS_DEACTIVATE, new String[0]);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        boolean inWorld = this.addon.getPlugin().getIWM().inWorld(b.getWorld());
        if (!b.getType().name().contains("SIGN") || inWorld && !this.addon.inRegisteredWorld(b.getWorld()) || !inWorld && !this.addon.getSettings().isAllowInOtherWorlds() || !this.isWarpSign(b)) {
            return;
        }
        User user = User.getInstance((Player)e.getPlayer());
        UUID owner = this.addon.getWarpSignsManager().getWarpOwnerUUID(b.getLocation()).orElse(null);
        if (this.isPlayersSign(e.getPlayer(), b, inWorld)) {
            this.addon.getWarpSignsManager().removeWarp(b.getLocation());
            Bukkit.getPluginManager().callEvent((Event)new WarpRemoveEvent(b.getLocation(), user.getUniqueId(), owner));
        } else {
            user.sendMessage("warps.error.no-remove", new String[0]);
            e.setCancelled(true);
        }
    }

    private boolean isPlayersSign(Player player, Block b, boolean inWorld) {
        Map<UUID, PlayerWarp> list = this.addon.getWarpSignsManager().getWarpMap(b.getWorld());
        String reqPerm = inWorld ? this.addon.getPermPrefix(b.getWorld()) + "mod.removesign" : "welcomewarpsigns.mod.removesign";
        return list.containsKey(player.getUniqueId()) && list.get(player.getUniqueId()).getLocation().equals((Object)b.getLocation()) || player.isOp() || player.hasPermission(reqPerm);
    }

    private boolean isWarpSign(Block b) {
        BlockState blockState = b.getState();
        if (blockState instanceof Sign) {
            Sign s = (Sign)blockState;
            SignSide side = s.getSide(Side.FRONT);
            return side.getLine(0).equalsIgnoreCase(String.valueOf(ChatColor.GREEN) + this.addon.getSettings().getWelcomeLine()) && this.addon.getWarpSignsManager().getWarpMap(b.getWorld()).values().stream().anyMatch(playerWarp -> playerWarp.getLocation().equals((Object)s.getLocation()));
        }
        return false;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignWarpCreate(SignChangeEvent e) {
        User user = Objects.requireNonNull(User.getInstance((Player)e.getPlayer()));
        Block b = e.getBlock();
        Location loc = b.getLocation();
        boolean inWorld = this.addon.getPlugin().getIWM().inWorld(b.getWorld());
        if (inWorld && !this.addon.inRegisteredWorld(b.getWorld()) || !inWorld && !this.addon.getSettings().isAllowInOtherWorlds()) {
            return;
        }
        String title = e.getLine(0);
        if (title != null && !title.equalsIgnoreCase(this.addon.getSettings().getWelcomeLine()) && this.addon.getWarpSignsManager().isWarpAt(loc)) {
            UUID owner = this.addon.getWarpSignsManager().getWarpOwnerUUID(loc).orElse(null);
            this.addon.getWarpSignsManager().removeWarp(loc);
            Bukkit.getPluginManager().callEvent((Event)new WarpRemoveEvent(loc, user.getUniqueId(), owner));
            return;
        }
        if (title != null && title.equalsIgnoreCase(this.addon.getSettings().getWelcomeLine())) {
            Block oldSignBlock;
            BlockState blockState;
            if (this.noPerms(user, b.getWorld(), inWorld)) {
                return;
            }
            if (inWorld && this.noLevelOrIsland(user, b.getWorld())) {
                e.setLine(0, String.valueOf(ChatColor.RED) + this.addon.getSettings().getWelcomeLine());
                return;
            }
            if (inWorld && !this.hasCorrectIslandRank(b, user)) {
                e.setLine(0, String.valueOf(ChatColor.RED) + this.addon.getSettings().getWelcomeLine());
                user.sendMessage("warps.error.not-correct-rank", new String[0]);
                return;
            }
            Location oldSignLoc = this.addon.getWarpSignsManager().getWarpLocation(b.getWorld(), user.getUniqueId());
            if (oldSignLoc != null && (blockState = (oldSignBlock = oldSignLoc.getBlock()).getState()) instanceof Sign) {
                Sign oldSign = (Sign)blockState;
                SignSide front = oldSign.getSide(Side.FRONT);
                SignSide back = oldSign.getSide(Side.BACK);
                String welcome = String.valueOf(ChatColor.GREEN) + this.addon.getSettings().getWelcomeLine();
                String disabled = String.valueOf(ChatColor.RED) + this.addon.getSettings().getWelcomeLine();
                boolean remove = false;
                if (front.getLine(0).equalsIgnoreCase(welcome)) {
                    front.setLine(0, disabled);
                    remove = true;
                } else if (back.getLine(0).equalsIgnoreCase(welcome)) {
                    back.setLine(0, disabled);
                    remove = true;
                }
                if (remove) {
                    oldSign.update(true, false);
                    user.sendMessage(WARPS_DEACTIVATE, new String[0]);
                    UUID owner = this.addon.getWarpSignsManager().getWarpOwnerUUID(oldSignLoc).orElse(null);
                    this.addon.getWarpSignsManager().removeWarp(oldSignBlock.getWorld(), user.getUniqueId());
                    Bukkit.getPluginManager().callEvent((Event)new WarpRemoveEvent(oldSign.getLocation(), user.getUniqueId(), owner));
                }
            }
            this.addSign(e, user, b);
        }
    }

    private boolean hasCorrectIslandRank(Block b, User user) {
        Optional islandOpt = this.plugin.getIslands().getIslandAt(b.getLocation());
        if (islandOpt.isEmpty()) {
            return false;
        }
        Island island = (Island)islandOpt.get();
        int userRank = island.getRank(user);
        return userRank >= island.getFlag(this.addon.getCreateWarpFlag());
    }

    @EventHandler
    public void onFlagChange(FlagProtectionChangeEvent e) {
        if (!e.getEditedFlag().equals((Object)this.addon.getCreateWarpFlag())) {
            return;
        }
        if (!this.addon.getSettings().getRemoveExistingWarpsWhenFlagChanges()) {
            return;
        }
        Island island = e.getIsland();
        Map<UUID, PlayerWarp> islandWarps = this.addon.getWarpSignsManager().getWarpMap(island.getWorld()).entrySet().stream().filter(x -> island.inIslandSpace(((PlayerWarp)x.getValue()).getLocation())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<UUID, PlayerWarp> entry : islandWarps.entrySet()) {
            if (island.getRank(entry.getKey()) >= e.getSetTo()) continue;
            this.addon.getWarpSignsManager().removeWarp(island.getWorld(), entry.getKey());
            if (Bukkit.getPlayer((UUID)entry.getKey()) == null) continue;
            Objects.requireNonNull(User.getInstance((UUID)entry.getKey())).sendMessage(WARPS_DEACTIVATE, new String[0]);
        }
    }

    private boolean noLevelOrIsland(User user, World world) {
        Long level = this.addon.getLevel(Util.getWorld((World)world), user.getUniqueId());
        if (level != null && level < (long)this.addon.getSettings().getWarpLevelRestriction()) {
            user.sendMessage("warps.error.not-enough-level", new String[0]);
            user.sendMessage("warps.error.your-level-is", new String[]{"[level]", String.valueOf(level), "[required]", String.valueOf(this.addon.getSettings().getWarpLevelRestriction())});
            return true;
        }
        if (!this.plugin.getIslands().userIsOnIsland(world, user)) {
            user.sendMessage("warps.error.not-on-island", new String[0]);
            return true;
        }
        return false;
    }

    private boolean noPerms(User user, World world, boolean inWorld) {
        String permReq;
        String string = permReq = inWorld ? this.addon.getPermPrefix(world) + "island.addwarp" : "welcomewarpsigns.addwarp";
        if (!user.hasPermission(permReq)) {
            user.sendMessage("warps.error.no-permission", new String[0]);
            user.sendMessage("general.errors.no-permission", new String[]{"[permission]", permReq});
            return true;
        }
        return false;
    }

    private void addSign(SignChangeEvent e, User user, Block b) {
        if (this.addon.getWarpSignsManager().addWarp(user.getUniqueId(), b.getLocation())) {
            user.sendMessage("warps.success", new String[0]);
            e.setLine(0, String.valueOf(ChatColor.GREEN) + this.addon.getSettings().getWelcomeLine());
            for (int i = 1; i < 4; ++i) {
                String line = e.getLine(i);
                if (line == null) continue;
                e.setLine(i, ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            HashMap<String, Object> keyValues = new HashMap<String, Object>();
            keyValues.put("eventName", "WarpCreateEvent");
            keyValues.put("targetPlayer", user.getUniqueId());
            keyValues.put("location", Util.getStringLocation((Location)b.getLocation()));
            new AddonEvent().builder().addon((Addon)this.addon).keyValues(keyValues).build();
        }
    }
}

