/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.database.Database;
import world.bentobox.warps.Warp;
import world.bentobox.warps.managers.SignCacheItem;
import world.bentobox.warps.objects.SignCache;

public class SignCacheManager {
    private final Map<World, Map<UUID, SignCacheItem>> cachedSigns = new HashMap<World, Map<UUID, SignCacheItem>>();
    private final Warp addon;
    private final Database<SignCache> handler;

    public SignCacheManager(Warp addon) {
        this.addon = addon;
        this.handler = new Database((Addon)addon, SignCache.class);
        this.loadCache();
    }

    private void loadCache() {
        this.cachedSigns.clear();
        this.handler.loadObjects().forEach(w -> {
            World world = Bukkit.getWorld((String)w.getUniqueId());
            if (world != null) {
                w.getSigns().values().removeIf(sci -> sci.getType().equals((Object)Material.AIR));
                this.cachedSigns.put(world, w.getSigns());
            }
        });
    }

    public void saveCache() {
        this.cachedSigns.forEach((w, m) -> this.handler.saveObjectAsync((Object)new SignCache((World)w, (Map<UUID, SignCacheItem>)m)));
    }

    public @NonNull SignCacheItem getSignItem(World world, UUID warpOwner) {
        this.cachedSigns.putIfAbsent(world, new HashMap());
        if (this.cachedSigns.get(world).containsKey(warpOwner)) {
            return this.cachedSigns.get(world).get(warpOwner);
        }
        SignCacheItem result = this.addon.getWarpSignsManager().getSignInfo(world, warpOwner);
        if (result.isReal()) {
            this.cachedSigns.get(world).put(warpOwner, result);
        } else {
            this.cachedSigns.get(world).remove(warpOwner);
        }
        return result;
    }

    public boolean removeWarp(World world, UUID key) {
        if (this.cachedSigns.containsKey(world)) {
            return this.cachedSigns.get(world).remove(key) != null;
        }
        return false;
    }
}

