/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;
import world.bentobox.warps.Warp;
import world.bentobox.warps.event.WarpCreateEvent;
import world.bentobox.warps.event.WarpInitiateEvent;
import world.bentobox.warps.managers.SignCacheItem;
import world.bentobox.warps.objects.PlayerWarp;
import world.bentobox.warps.objects.WarpsData;
import world.bentobox.warps.panels.Utils;

public class WarpSignsManager {
    private static final int MAX_WARPS = 600;
    private static final String WARPS = "warps";
    private final BentoBox plugin;
    private Map<World, Map<UUID, PlayerWarp>> worldsWarpList;
    private final Database<WarpsData> handler;
    private final Warp addon;
    private WarpsData warpsData = new WarpsData();

    public @NonNull Map<UUID, PlayerWarp> getWarpMap(@Nullable World world) {
        return this.worldsWarpList.computeIfAbsent(Util.getWorld((World)world), k -> new HashMap());
    }

    public WarpSignsManager(Warp addon, BentoBox plugin) {
        this.addon = addon;
        this.plugin = plugin;
        this.worldsWarpList = new HashMap<World, Map<UUID, PlayerWarp>>();
        this.handler = new Database((Addon)addon, WarpsData.class);
        this.loadWarpList();
    }

    public boolean addWarp(UUID playerUUID, Location loc) {
        if (playerUUID == null || loc == null) {
            return false;
        }
        for (PlayerWarp playerWarp : this.getWarpMap(loc.getWorld()).values()) {
            if (!playerWarp.getLocation().equals((Object)loc)) continue;
            this.removeWarp(loc);
            break;
        }
        this.getWarpMap(loc.getWorld()).put(playerUUID, new PlayerWarp(loc, true));
        this.saveWarpList();
        Bukkit.getPluginManager().callEvent((Event)new WarpCreateEvent(this.addon, loc, playerUUID));
        return true;
    }

    public @Nullable Location getWarpLocation(World world, UUID playerUUID) {
        PlayerWarp playerWarp = this.getWarpMap(world).get(playerUUID);
        return playerWarp != null ? playerWarp.getLocation() : null;
    }

    public @Nullable PlayerWarp getPlayerWarp(World world, UUID playerUUID) {
        return this.getWarpMap(world).get(playerUUID);
    }

    public @NonNull String getWarpOwner(Location location) {
        return this.getWarpMap(location.getWorld()).entrySet().stream().filter(en -> ((PlayerWarp)en.getValue()).getLocation().equals((Object)location)).findFirst().map(en -> this.plugin.getPlayers().getName((UUID)en.getKey())).orElse("");
    }

    public Optional<UUID> getWarpOwnerUUID(Location location) {
        return this.getWarpMap(location.getWorld()).entrySet().stream().filter(en -> ((PlayerWarp)en.getValue()).getLocation().equals((Object)location)).findFirst().map(Map.Entry::getKey);
    }

    public boolean isWarpAt(Location location) {
        return this.getWarpMap(location.getWorld()).entrySet().stream().map(en -> ((PlayerWarp)en.getValue()).getLocation().equals((Object)location)).findFirst().isPresent();
    }

    public CompletableFuture<List<UUID>> getSortedWarps(@NonNull World world) {
        CompletableFuture<List<UUID>> r = new CompletableFuture<List<UUID>>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.processWarpMap(r, world));
        return r;
    }

    public List<UUID> processWarpMap(CompletableFuture<List<UUID>> r, @NonNull World world) {
        this.getWarpMap(world).values().removeIf(Objects::isNull);
        TreeMap map = new TreeMap();
        this.getWarpMap(world).forEach((uuid, value) -> {
            if (!value.isEnabled()) {
                return;
            }
            long lastPlayed = this.addon.getServer().getOfflinePlayer(uuid).getLastPlayed();
            if (!map.isEmpty() && map.containsKey(lastPlayed)) {
                lastPlayed = (Long)map.firstKey() - 1L;
            }
            map.put(lastPlayed, uuid);
        });
        Collection result = map.descendingMap().values();
        ArrayList<UUID> list = new ArrayList<UUID>(result);
        if (list.size() > 600) {
            list.subList(0, 600).clear();
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> r.complete(list));
        return list;
    }

    public @NonNull Set<UUID> listWarps(@NonNull World world) {
        this.getWarpMap(world).values().removeIf(Objects::isNull);
        Map<UUID, PlayerWarp> enabledWarps = this.getWarpMap(world).entrySet().stream().filter(entry -> ((PlayerWarp)entry.getValue()).isEnabled()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return enabledWarps.keySet();
    }

    public void loadWarpList() {
        this.addon.log("Loading warps...");
        this.worldsWarpList = new HashMap<World, Map<UUID, PlayerWarp>>();
        if (this.handler.objectExists(WARPS)) {
            this.warpsData = (WarpsData)this.handler.loadObject(WARPS);
            if (this.warpsData != null) {
                this.warpsData.getWarpSigns().forEach((pw, uuid) -> {
                    Location location = pw.getLocation();
                    if (location != null && location.getWorld() != null) {
                        if (location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4) && !location.getBlock().getType().name().contains("SIGN")) {
                            return;
                        }
                        this.getWarpMap(location.getWorld()).put((UUID)uuid, new PlayerWarp(location, true));
                    }
                });
            } else {
                this.warpsData = new WarpsData();
            }
        }
    }

    private void popSign(Location loc) {
        Sign s;
        Block b = loc.getBlock();
        if (b.getType().name().contains("SIGN") && (s = (Sign)b.getState()).getLine(0).equalsIgnoreCase(String.valueOf(ChatColor.GREEN) + this.addon.getSettings().getWelcomeLine())) {
            s.setLine(0, String.valueOf(ChatColor.RED) + this.addon.getSettings().getWelcomeLine());
            s.update(true, false);
        }
    }

    public void removeWarp(Location loc) {
        this.popSign(loc);
        Iterator<Map.Entry<UUID, PlayerWarp>> it = this.getWarpMap(loc.getWorld()).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, PlayerWarp> en = it.next();
            if (!en.getValue().getLocation().equals((Object)loc)) continue;
            Optional.ofNullable(this.addon.getServer().getPlayer(en.getKey())).map(User::getInstance).ifPresent(user -> user.sendMessage("warps.sign-removed", new String[0]));
            this.addon.getSignCacheManager().removeWarp(loc.getWorld(), en.getKey());
            it.remove();
        }
        this.saveWarpList();
    }

    public void removeWarp(World world, UUID uuid) {
        if (this.getWarpMap(world).containsKey(uuid)) {
            this.popSign(this.getWarpMap(world).get(uuid).getLocation());
            this.getWarpMap(world).remove(uuid);
        }
        this.addon.getSignCacheManager().removeWarp(world, uuid);
        this.saveWarpList();
    }

    public void removeWarpFromMap(World world, UUID uuid) {
        this.getWarpMap(world).remove(uuid);
    }

    public void saveWarpList() {
        this.handler.saveObjectAsync((Object)this.warpsData.save(this.worldsWarpList));
        this.addon.getSignCacheManager().saveCache();
    }

    public @NonNull SignCacheItem getSignInfo(@NonNull World world, @NonNull UUID uuid) {
        Location signLocation = this.getWarpLocation(world, uuid);
        if (signLocation == null || !signLocation.getBlock().getType().name().contains("SIGN")) {
            return new SignCacheItem();
        }
        Sign sign = (Sign)signLocation.getBlock().getState();
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(sign.getLines()));
        result.remove(0);
        result.removeIf(String::isEmpty);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)this.addon.getSettings().getLoreFormat()) + (String)result.get(i));
        }
        String prefix = this.plugin.getIWM().getAddon(world).map(Addon::getPermissionPrefix).orElse("");
        Material icon = !prefix.isEmpty() ? Material.matchMaterial((String)Utils.getPermissionValue(User.getInstance((UUID)uuid), prefix + "island.warp", Material.OAK_SIGN.name())) : null;
        if (icon != null && icon.name().contains("SIGN")) {
            return new SignCacheItem(result, Material.valueOf((String)sign.getType().name().replace("WALL_", "")));
        }
        return new SignCacheItem(result, icon);
    }

    private void warpPlayer(@NonNull User user, @NonNull Location inFront, @NonNull UUID signOwner, @NonNull BlockFace directionFacing, boolean pvp) {
        float yaw = Util.blockFaceToFloat((BlockFace)directionFacing);
        Location actualWarp = new Location(inFront.getWorld(), (double)inFront.getBlockX() + 0.5, (double)inFront.getBlockY(), (double)inFront.getBlockZ() + 0.5, yaw, 30.0f);
        WarpInitiateEvent e = new WarpInitiateEvent(this.addon, actualWarp, user.getUniqueId());
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        Util.teleportAsync((Entity)user.getPlayer(), (Location)actualWarp, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(tpResult -> {
            if (Boolean.FALSE.equals(tpResult)) {
                return;
            }
            User warpOwner = Objects.requireNonNull(User.getInstance((UUID)signOwner));
            if (warpOwner.isOnline() && !warpOwner.getPlayer().canSee(user.getPlayer())) {
                return;
            }
            if (pvp) {
                user.sendMessage("protection.flags.PVP_OVERWORLD.enabled", new String[0]);
                user.getWorld().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_ARROW_HIT, 1.0f, 1.0f);
            } else {
                user.getWorld().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_BAT_TAKEOFF, 1.0f, 1.0f);
            }
            if (!warpOwner.equals((Object)user)) {
                String gameMode = BentoBox.getInstance().getIWM().getFriendlyName(actualWarp.getWorld());
                warpOwner.sendMessage("warps.player-warped", new String[]{"[name]", user.getName(), "[gamemode]", gameMode});
            }
        });
    }

    public void warpPlayer(@NonNull World world, @NonNull User user, @NonNull UUID owner) {
        Block b;
        Location warpSpot = this.getWarpLocation(world, owner);
        if (warpSpot == null) {
            user.sendMessage("warps.error.does-not-exist", new String[0]);
            this.addon.getWarpSignsManager().removeWarp(world, owner);
            return;
        }
        if (this.plugin.getIWM().inWorld(user.getWorld()) && Flags.PREVENT_TELEPORT_WHEN_FALLING.isSetForWorld(user.getWorld()) && user.getPlayer().getFallDistance() > 0.0f) {
            user.sendMessage(Flags.PREVENT_TELEPORT_WHEN_FALLING.getHintReference(), new String[0]);
            return;
        }
        Island island = this.addon.getIslands().getIsland(world, owner);
        boolean pvp = false;
        if (island != null) {
            switch (Objects.requireNonNull(warpSpot.getWorld()).getEnvironment()) {
                case NETHER: {
                    pvp = island.isAllowed(Flags.PVP_NETHER);
                    break;
                }
                case NORMAL: {
                    pvp = island.isAllowed(Flags.PVP_OVERWORLD);
                    break;
                }
                case THE_END: {
                    pvp = island.isAllowed(Flags.PVP_END);
                    break;
                }
            }
        }
        if (Tag.WALL_SIGNS.isTagged((Keyed)(b = warpSpot.getBlock()).getType())) {
            s = (WallSign)b.getBlockData();
            BlockFace directionFacing = s.getFacing();
            Location inFront = b.getRelative(directionFacing).getLocation();
            Location oneDown = b.getRelative(directionFacing).getRelative(BlockFace.DOWN).getLocation();
            if (this.plugin.getIslands().isSafeLocation(inFront)) {
                this.warpPlayer(user, inFront, owner, directionFacing, pvp);
                return;
            }
            if (this.plugin.getIslands().isSafeLocation(oneDown)) {
                this.warpPlayer(user, oneDown, owner, directionFacing, pvp);
                return;
            }
        } else if (Tag.ALL_HANGING_SIGNS.isTagged((Keyed)b.getType())) {
            Location below = b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN).getLocation();
            if (this.addon.getIslands().isSafeLocation(below)) {
                this.warpPlayer(user, below, owner, BlockFace.DOWN, pvp);
                return;
            }
        } else if (Tag.STANDING_SIGNS.isTagged((Keyed)b.getType())) {
            s = (org.bukkit.block.data.type.Sign)b.getBlockData();
            BlockFace directionFacing = s.getRotation();
            Location inFront = b.getRelative(directionFacing).getLocation();
            if (this.addon.getIslands().isSafeLocation(inFront)) {
                this.warpPlayer(user, inFront, owner, directionFacing, pvp);
                return;
            }
        } else {
            user.sendMessage("warps.error.does-not-exist", new String[0]);
            this.removeWarp(warpSpot);
            return;
        }
        if (!this.plugin.getIslands().isSafeLocation(warpSpot)) {
            user.sendMessage("warps.error.not-safe", new String[0]);
        } else {
            Location actualWarp = new Location(warpSpot.getWorld(), (double)warpSpot.getBlockX() + 0.5, (double)warpSpot.getBlockY(), (double)warpSpot.getBlockZ() + 0.5);
            if (pvp) {
                user.sendMessage("protection.flags.PVP_OVERWORLD.enabled", new String[0]);
                user.getWorld().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_ARROW_HIT, 1.0f, 1.0f);
            } else {
                user.getWorld().playSound(Objects.requireNonNull(user.getLocation()), Sound.ENTITY_BAT_TAKEOFF, 1.0f, 1.0f);
            }
            Util.teleportAsync((Entity)user.getPlayer(), (Location)actualWarp, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.COMMAND);
        }
    }

    public boolean hasWarp(@NonNull World world, @NonNull UUID playerUUID) {
        return this.getWarpMap(world).containsKey(playerUUID);
    }
}

