/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.objects;

import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;
import world.bentobox.warps.objects.PlayerWarp;

@Table(name="WarpsData")
public class WarpsData
implements DataObject {
    @Expose
    private String uniqueId = "warps";
    @Deprecated
    @Expose
    private Map<Location, UUID> warpSigns = new HashMap<Location, UUID>();
    @Expose
    private Map<PlayerWarp, UUID> newWarpSigns = new HashMap<PlayerWarp, UUID>();

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Map<PlayerWarp, UUID> getWarpSigns() {
        this.convertOldWarpSigns();
        if (this.newWarpSigns == null) {
            return new HashMap<PlayerWarp, UUID>();
        }
        return this.newWarpSigns;
    }

    public void convertOldWarpSigns() {
        if (this.warpSigns == null) {
            return;
        }
        for (Map.Entry<Location, UUID> entry : this.warpSigns.entrySet()) {
            PlayerWarp playerWarp = new PlayerWarp(entry.getKey(), true);
            this.newWarpSigns.put(playerWarp, entry.getValue());
        }
        this.warpSigns = null;
    }

    public void setWarpSigns(Map<PlayerWarp, UUID> warpSigns) {
        this.newWarpSigns = warpSigns;
    }

    public WarpsData save(Map<World, Map<UUID, PlayerWarp>> worldsWarpList) {
        this.getWarpSigns().clear();
        worldsWarpList.values().forEach(world -> world.forEach((uuid, playerWarp) -> this.newWarpSigns.put((PlayerWarp)playerWarp, (UUID)uuid)));
        return this;
    }
}

