/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.warps.panels;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.warps.Warp;
import world.bentobox.warps.managers.SignCacheItem;
import world.bentobox.warps.managers.SignCacheManager;
import world.bentobox.warps.panels.Utils;

public class WarpsPanel {
    private final Warp addon;
    private final SignCacheManager manager;
    private final User user;
    private final World world;
    private List<UUID> elementList;
    private int pageIndex;
    private static final Random random = new Random();

    private WarpsPanel(Warp addon, World world, User user) {
        this.addon = addon;
        this.manager = this.addon.getSignCacheManager();
        this.user = user;
        this.world = world;
    }

    private void collectValidWarps(CompletableFuture<Boolean> completed) {
        this.addon.getWarpSignsManager().getSortedWarps(this.world).thenAccept(warps -> {
            Iterator iterator = warps.iterator();
            while (iterator.hasNext()) {
                UUID warpOwner = (UUID)iterator.next();
                @NonNull SignCacheItem sign = this.manager.getSignItem(this.world, warpOwner);
                if (sign.isReal()) continue;
                iterator.remove();
                this.addon.getWarpSignsManager().removeWarpFromMap(this.world, warpOwner);
            }
            this.elementList = warps;
            completed.complete(true);
        });
    }

    private void initBuild() {
        CompletableFuture<Boolean> collectWarps = new CompletableFuture<Boolean>();
        this.collectValidWarps(collectWarps);
        collectWarps.thenAccept(done -> {
            if (done.booleanValue()) {
                this.build();
            }
        });
    }

    private void build() {
        if (this.elementList.isEmpty()) {
            this.addon.logError("There are no available islands for visiting!");
            Utils.sendMessage(this.user, "warps.error.no-warps-yet", "[gamemode]", this.addon.getPlugin().getIWM().getAddon(this.world).map(gamemode -> gamemode.getDescription().getName()).orElse(""));
            return;
        }
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        panelBuilder.template("warps_panel", new File(this.addon.getDataFolder(), "panels"));
        panelBuilder.user(this.user);
        panelBuilder.world(this.user.getWorld());
        panelBuilder.registerTypeBuilder("WARP", this::createWarpButton);
        panelBuilder.registerTypeBuilder("RANDOM", this::createRandomButton);
        panelBuilder.registerTypeBuilder("NEXT", this::createNextButton);
        panelBuilder.registerTypeBuilder("PREVIOUS", this::createPreviousButton);
        panelBuilder.build();
    }

    private @Nullable PanelItem createNextButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        int size = this.elementList.size();
        if (size <= slot.amountMap().getOrDefault("WARP", 1) || 1.0 * (double)size / (double)slot.amountMap().getOrDefault("WARP", 1).intValue() <= (double)(this.pageIndex + 1)) {
            return null;
        }
        int nextPageIndex = this.pageIndex + 2;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (template.dataMap().getOrDefault("indexing", false).booleanValue()) {
                clone.setAmount(nextPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.world, template.description(), new String[]{"[number]", String.valueOf(nextPageIndex)}));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "NEXT".equalsIgnoreCase(action.actionType())) {
                    ++this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createPreviousButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.pageIndex == 0) {
            return null;
        }
        int previousPageIndex = this.pageIndex;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (template.dataMap().getOrDefault("indexing", false).booleanValue()) {
                clone.setAmount(previousPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.world, template.description(), new String[]{"[number]", String.valueOf(previousPageIndex)}));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "PREVIOUS".equalsIgnoreCase(action.actionType())) {
                    --this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createWarpButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.elementList.isEmpty()) {
            return null;
        }
        int index = this.pageIndex * slot.amountMap().getOrDefault("WARP", 1) + slot.slot();
        if (index >= this.elementList.size()) {
            return null;
        }
        return this.createWarpButton(template, this.elementList.get(index), "warp");
    }

    private @Nullable PanelItem createRandomButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.elementList.size() < 2) {
            return null;
        }
        int index = random.nextInt(this.elementList.size());
        return this.createWarpButton(template, this.elementList.get(index), "random");
    }

    private PanelItem createWarpButton(ItemTemplateRecord template, UUID ownerUUID, String type) {
        String descriptionText;
        if (ownerUUID == null) {
            return null;
        }
        SignCacheItem signCache = this.manager.getSignItem(this.world, ownerUUID);
        if (!signCache.isReal()) {
            this.addon.getWarpSignsManager().removeWarpFromMap(this.world, ownerUUID);
            return null;
        }
        String reference = "warps.gui.buttons." + type + ".";
        String ownerName = this.addon.getPlugin().getPlayers().getName(ownerUUID);
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            if (template.icon().getType().equals((Object)Material.PLAYER_HEAD)) {
                builder.icon(ownerName);
            } else {
                builder.icon(template.icon().clone());
            }
        } else {
            Material material = signCache.getType();
            if (material == null) {
                material = Material.OAK_SIGN;
            }
            if (material == Material.PLAYER_HEAD) {
                builder.icon(ownerName);
            } else {
                builder.icon(material);
            }
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.world, template.title(), new String[]{"[name]", ownerName}));
        } else {
            builder.name(this.user.getTranslation(reference + "name", new String[]{"[name]", ownerName}));
        }
        if (template.description() != null) {
            descriptionText = this.user.getTranslationOrNothing(template.description(), new String[]{"[name]", ownerName, "[sign_text]", String.join((CharSequence)"\n", signCache.getSignText())}).replaceAll("(?m)^[ \\t]*\\r?\\n", "").replaceAll("(?<!\\\\)\\|", "\n").replaceAll("\\\\\\|", "|");
        } else {
            descriptionText = this.user.getTranslationOrNothing(reference + "description", new String[]{"[name]", ownerName, "[sign_text]", String.join((CharSequence)"|", signCache.getSignText())});
            descriptionText = descriptionText.replaceAll("(?m)^[ \\t]*\\r?\\n", "").replaceAll("(?<!\\\\)\\|", "\n").replaceAll("\\\\\\|", "|");
        }
        builder.description(descriptionText);
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "WARP".equalsIgnoreCase(action.actionType())) {
                    this.runCommandCall(ownerName);
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.world, action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private void runCommandCall(String ownerName) {
        String command = this.addon.getSettings().getWarpCommand().split(" ")[0];
        String gamemodeCommand = this.addon.getPlugin().getIWM().getAddon(this.world).map(gamemode -> gamemode.getPlayerCommand().map(Command::getLabel).orElse("")).orElse("");
        if (gamemodeCommand.isEmpty()) {
            this.addon.log(this.user.getName() + " called: `" + command + " " + ownerName + "`");
            this.user.performCommand(command + " " + ownerName);
        } else {
            this.addon.log(this.user.getName() + " called: `" + gamemodeCommand + " " + command + " " + ownerName + "`");
            this.user.performCommand(gamemodeCommand + " " + command + " " + ownerName);
        }
        this.user.closeInventory();
    }

    public static void openPanel(Warp addon, World world, User user) {
        new WarpsPanel(addon, world, user).initBuild();
    }
}

