/*
 * Decompiled with CFR 0.152.
 */
package artifacts.attribute;

import artifacts.Artifacts;
import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.EntityAccessor;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModTags;
import java.util.Objects;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_6025;
import net.minecraft.class_6880;

public abstract class DynamicAttributeModifier {
    private static final DynamicAttributeModifier MOUNT_SPEED = new DynamicAttributeModifier(Artifacts.id("mount_speed"), class_5134.field_23719, class_1322.class_1323.field_6330){

        @Override
        protected boolean shouldApply(class_1309 entity) {
            return entity.method_5642() != null;
        }

        @Override
        protected double getAmount(class_1309 entity) {
            return Objects.requireNonNull(entity.method_5642()).method_45325(ModAttributes.MOUNT_SPEED) - 1.0;
        }
    };
    private static final DynamicAttributeModifier SPRINTING_SPEED = new DynamicAttributeModifier(Artifacts.id("sprinting_speed"), class_5134.field_23719, class_1322.class_1323.field_6330){

        @Override
        protected boolean shouldApply(class_1309 entity) {
            return entity.method_5624();
        }

        @Override
        protected double getAmount(class_1309 entity) {
            return entity.method_45325(ModAttributes.SPRINTING_SPEED) - 1.0;
        }
    };
    private static final DynamicAttributeModifier SPRINTING_STEP_HEIGHT = new DynamicAttributeModifier(Artifacts.id("sprinting_step_height"), class_5134.field_47761, class_1322.class_1323.field_6328){

        @Override
        protected boolean shouldApply(class_1309 entity) {
            return entity.method_5624();
        }

        @Override
        protected double getAmount(class_1309 entity) {
            return entity.method_45325(ModAttributes.SPRINTING_STEP_HEIGHT);
        }
    };
    private static final DynamicAttributeModifier UMBRELLA_GRAVITY = new DynamicAttributeModifier(Artifacts.id("umbrella_gravity"), class_5134.field_49078, class_1322.class_1323.field_6331){

        @Override
        protected boolean shouldApply(class_1309 entity) {
            return UmbrellaItem.shouldGlide(entity);
        }

        @Override
        protected double getAmount(class_1309 entity) {
            return -0.875;
        }
    };
    private static final DynamicAttributeModifier MOVEMENT_SPEED_ON_SNOW = new DynamicAttributeModifier(Artifacts.id("movement_speed_on_snow"), class_5134.field_23719, class_1322.class_1323.field_6330){

        @Override
        protected boolean shouldApply(class_1309 entity) {
            if (entity.method_24828() && entity instanceof EntityAccessor) {
                EntityAccessor entityAccessor = (EntityAccessor)entity;
                if (entity.method_45325(ModAttributes.MOVEMENT_SPEED_ON_SNOW) != 1.0) {
                    class_2680 onState = entity.method_37908().method_8320(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement());
                    if (onState.method_26164(class_3481.field_29823)) {
                        return true;
                    }
                    class_2680 aboveState = entity.method_37908().method_8320(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement().method_10084());
                    return !aboveState.method_26215() && aboveState.method_26164(ModTags.SNOW_LAYERS);
                }
            }
            return false;
        }

        @Override
        protected double getAmount(class_1309 entity) {
            return entity.method_45325(ModAttributes.MOVEMENT_SPEED_ON_SNOW) - 1.0;
        }
    };
    private final class_6880<class_1320> attribute;
    private final class_1322.class_1323 operation;
    private final class_2960 id;

    public DynamicAttributeModifier(class_2960 id, class_6880<class_1320> attribute, class_1322.class_1323 operation) {
        this.attribute = attribute;
        this.operation = operation;
        this.id = id;
    }

    protected abstract boolean shouldApply(class_1309 var1);

    protected abstract double getAmount(class_1309 var1);

    private void tick(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(this.attribute);
        if (attributeInstance == null) {
            return;
        }
        if (this.shouldApply(entity)) {
            double amount = this.getAmount(entity);
            class_1322 modifier = attributeInstance.method_6199(this.id);
            if (modifier == null || modifier.comp_2449() != amount) {
                attributeInstance.method_55696(new class_1322(this.id, amount, this.operation));
            }
        } else if (attributeInstance.method_6196(this.id)) {
            attributeInstance.method_6200(this.id);
        }
    }

    private static boolean shouldUpdateModifiers(class_1309 entity) {
        class_6025 ownable;
        class_1308 mob;
        if (entity.field_6012 % 10 != 0) {
            return entity instanceof class_1657 || entity.method_5642() instanceof class_1657;
        }
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() != null || entity instanceof class_6025 && (ownable = (class_6025)entity).method_35057() instanceof class_1657) {
            return true;
        }
        return entity.field_6012 % 20 == 0;
    }

    public static void tickModifiers(class_1309 entity) {
        block9: {
            block8: {
                block7: {
                    if (!DynamicAttributeModifier.shouldUpdateModifiers(entity)) {
                        return;
                    }
                    if (entity.method_48155()) {
                        SPRINTING_SPEED.tick(entity);
                        SPRINTING_STEP_HEIGHT.tick(entity);
                    }
                    if (!(entity instanceof class_1657)) break block7;
                    class_1657 player = (class_1657)entity;
                    if (player.method_31549().field_7479) break block8;
                }
                if (!entity.method_24828() && !entity.method_6128()) break block9;
            }
            MOVEMENT_SPEED_ON_SNOW.tick(entity);
        }
        if (entity instanceof class_1657) {
            UMBRELLA_GRAVITY.tick(entity);
        }
        if (entity instanceof class_5146) {
            MOUNT_SPEED.tick(entity);
        }
    }
}

