/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidCollision(Value<Boolean> enabled, Optional<class_6862<class_3611>> tag, EntityCondition condition) implements TickingAbility
{
    public static Codec<FluidCollision> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.enabledField().forGetter(FluidCollision::enabled), (App)class_6862.method_40090((class_5321)class_7924.field_41270).optionalFieldOf("tag").forGetter(FluidCollision::tag), (App)EntityCondition.CODEC.optionalFieldOf("condition", (Object)EntityCondition.ALWAYS).forGetter(FluidCollision::condition)).apply((Applicative)instance, FluidCollision::new));
    public static class_9139<ByteBuf, FluidCollision> STREAM_CODEC = class_9139.method_56436(ValueTypes.BOOLEAN.streamCodec(), FluidCollision::enabled, (class_9139)class_9135.method_56382(ModCodecs.tagKeyStreamCodec(class_7924.field_41270)), FluidCollision::tag, EntityCondition.STREAM_CODEC, FluidCollision::condition, FluidCollision::new);

    @Override
    public void wornTick(class_1309 entity, boolean isOnCooldown, boolean isDisabled) {
        class_3610 fluidState = entity.method_25936().method_26227();
        if (fluidState.method_15767(class_3486.field_15518) && !entity.method_5753() && this.condition.test(entity)) {
            entity.method_5643(entity.method_48923().method_48820(), 1.0f);
        }
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    public boolean matchesFluid(class_3610 fluidState) {
        return this.tag().isEmpty() || fluidState.method_15767(this.tag().get());
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (this.condition == EntityCondition.SNEAKING && this.tag().isPresent() && this.tag().get().equals((Object)class_3486.field_15518)) {
            writer.add("sneaking.lava", new Object[0]);
        } else if (this.condition == EntityCondition.SPRINTING && this.tag().isEmpty()) {
            writer.add("sprinting", new Object[0]);
        }
    }
}

