/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AttackEffects(List<Entry> entries) implements CompositeAbility<Entry>
{
    private static final Set<class_6880<class_1291>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(class_1294.field_5920);
    public static final Codec<AttackEffects> CODEC = Entry.CODEC.listOf().xmap(AttackEffects::new, AttackEffects::entries);
    public static final class_9139<class_9129, AttackEffects> STREAM_CODEC = class_9135.method_56363().apply(Entry.STREAM_CODEC).method_56432(AttackEffects::new, AttackEffects::entries);

    public static void onLivingHurt(class_1309 entity, class_1282 damageSource) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.method_37908().method_8608()) {
            EquipmentHelper.iterateAbilities(ModDataComponents.ATTACK_EFFECTS.get(), attacker, true, true, (ability, stack) -> {
                for (Entry effect : ability.entries) {
                    if (!effect.shouldApply(entity)) continue;
                    entity.method_37222(effect.provider().createEffect(), (class_1297)attacker);
                    if (!(attacker instanceof class_1657)) continue;
                    class_1657 player = (class_1657)attacker;
                    player.method_7357().method_7906(stack.method_7909(), (Integer)effect.cooldown().get() * 20);
                }
            });
        }
    }

    public record Entry(MobEffectProvider provider, Value<Double> chance, Value<Integer> cooldown) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectProvider.codec(true).fieldOf("effect").forGetter(Entry::provider), (App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(Entry::chance), (App)ValueTypes.DURATION.codec().optionalFieldOf("cooldown", Value.of(1)).forGetter(Entry::cooldown)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56436(MobEffectProvider.STREAM_CODEC, Entry::provider, ValueTypes.FRACTION.streamCodec(), Entry::chance, ValueTypes.DURATION.streamCodec(), Entry::cooldown, Entry::new);

        public boolean shouldApply(class_1309 entity) {
            return this.isNonCosmetic() && (Double)this.chance().get() > entity.method_59922().method_43058();
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider().isNonCosmetic() && (Double)this.chance().get() > 0.0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            for (class_6880<class_1291> mobEffect : CUSTOM_TOOLTIP_MOB_EFFECTS) {
                if (!mobEffect.method_40227() || mobEffect.comp_349() != this.provider.mobEffect().comp_349() || !this.isNonCosmetic()) continue;
                String name = Objects.requireNonNull(class_7923.field_41174.method_10221((Object)((class_1291)mobEffect.comp_349()))).method_12832();
                if (class_3532.method_20390((double)((Double)this.chance().get()), (double)1.0)) {
                    writer.add(name + ".constant", new Object[0]);
                } else {
                    writer.add(name + ".chance", new Object[0]);
                }
                return;
            }
        }
    }
}

