/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.EntityCondition;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record MobEffectProvider(class_6880<class_1291> mobEffect, Value<Integer> level, Value<Integer> duration, Value<Boolean> spawnParticles, Value<Boolean> showIcon, EntityCondition condition) {
    public static final class_9139<class_9129, MobEffectProvider> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), MobEffectProvider::mobEffect, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), MobEffectProvider::level, ValueTypes.DURATION.streamCodec(), MobEffectProvider::duration, ValueTypes.BOOLEAN.streamCodec(), MobEffectProvider::spawnParticles, ValueTypes.BOOLEAN.streamCodec(), MobEffectProvider::showIcon, EntityCondition.STREAM_CODEC, MobEffectProvider::condition, MobEffectProvider::new);

    public static Codec<MobEffectProvider> codec(boolean showParticles) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41174.method_40294().fieldOf("id").forGetter(MobEffectProvider::mobEffect), (App)ValueTypes.MOB_EFFECT_LEVEL.codec().optionalFieldOf("level", Value.of(1)).forGetter(MobEffectProvider::level), (App)ValueTypes.DURATION.codec().optionalFieldOf("duration", Value.of(10)).forGetter(MobEffectProvider::duration), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("spawn_particles", Value.of(showParticles)).forGetter(MobEffectProvider::spawnParticles), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("show_icon", Value.of(false)).forGetter(MobEffectProvider::showIcon), (App)EntityCondition.CODEC.optionalFieldOf("condition", (Object)EntityCondition.ALWAYS).forGetter(MobEffectProvider::condition)).apply((Applicative)instance, MobEffectProvider::new));
    }

    public int getDuration(int multiplier) {
        return (Integer)this.duration().get() * 20 * multiplier + 19;
    }

    public int getAmplifier() {
        return (Integer)this.level().get() - 1;
    }

    public boolean isNonCosmetic() {
        return (Integer)this.level().get() > 0 && (Integer)this.duration().get() > 0 && this.condition() != EntityCondition.NEVER;
    }

    public boolean canApply(class_1309 entity) {
        return this.isNonCosmetic() && this.condition.test(entity);
    }

    public class_1293 createEffect() {
        return this.createEffect(1);
    }

    public class_1293 createEffect(int multiplier) {
        return new class_1293(this.mobEffect(), this.getDuration(multiplier), this.getAmplifier(), false, ((Boolean)this.spawnParticles().get()).booleanValue(), ((Boolean)this.showIcon().get()).booleanValue());
    }
}

