/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.retaliation.FireEffect;
import artifacts.component.ability.retaliation.LightningEffect;
import artifacts.component.ability.retaliation.RetaliationEffect;
import artifacts.component.ability.retaliation.ThornsEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RetaliationEffects(Optional<ThornsEffect> thorns, Optional<FireEffect> fire, Optional<LightningEffect> lightning) implements EquipmentAbility
{
    public static final Codec<RetaliationEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ThornsEffect.CODEC.optionalFieldOf("thorns").forGetter(RetaliationEffects::thorns), (App)FireEffect.CODEC.optionalFieldOf("thorns").forGetter(RetaliationEffects::fire), (App)LightningEffect.CODEC.optionalFieldOf("thorns").forGetter(RetaliationEffects::lightning)).apply((Applicative)instance, RetaliationEffects::new));
    public static final class_9139<ByteBuf, RetaliationEffects> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56382(ThornsEffect.STREAM_CODEC), RetaliationEffects::thorns, (class_9139)class_9135.method_56382(FireEffect.STREAM_CODEC), RetaliationEffects::fire, (class_9139)class_9135.method_56382(LightningEffect.STREAM_CODEC), RetaliationEffects::lightning, RetaliationEffects::new);

    public void onLivingHurt(class_1309 entity, class_1799 stack, class_1282 damageSource) {
        this.thorns.ifPresent(effect -> effect.onLivingHurt(entity, stack, damageSource));
        this.fire.ifPresent(effect -> effect.onLivingHurt(entity, stack, damageSource));
        this.lightning.ifPresent(effect -> effect.onLivingHurt(entity, stack, damageSource));
    }

    @Override
    public boolean isNonCosmetic() {
        return this.thorns.isPresent() && this.thorns.get().isNonCosmetic() || this.fire.isPresent() && this.fire.get().isNonCosmetic() || this.lightning.isPresent() && this.lightning.get().isNonCosmetic();
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        this.addToTooltip(writer, this.thorns);
        this.addToTooltip(writer, this.fire);
        this.addToTooltip(writer, this.lightning);
    }

    private void addToTooltip(EquipmentAbility.TooltipWriter writer, Optional<? extends RetaliationEffect> effect) {
        if (effect.isPresent() && effect.get().isNonCosmetic()) {
            effect.get().addToTooltip(writer);
        }
    }
}

