/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config.value.type;

import artifacts.config.screen.ConfigEntries;
import artifacts.config.value.type.ValueType;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class EnumValueType<T extends Enum<T>>
extends ValueType<T, String> {
    private final Function<T, class_2561> toText;
    private final Class<T> enumClass;

    public EnumValueType(Class<T> enumClass, Function<T, class_2561> toText) {
        this.enumClass = enumClass;
        this.toText = toText;
    }

    public List<T> getValues() {
        return Arrays.asList((Enum[])this.enumClass.getEnumConstants());
    }

    @Override
    public boolean isCorrect(T value) {
        return true;
    }

    @Override
    public String makeError(T value) {
        return "";
    }

    @Override
    public String getAllowedValuesComment() {
        StringBuilder builder = new StringBuilder("Allowed Values: ");
        builder.append(((class_3542)((Enum[])this.enumClass.getEnumConstants())[0]).method_15434());
        for (int i = 1; i < ((Enum[])this.enumClass.getEnumConstants()).length; ++i) {
            builder.append(", ").append(((class_3542)((Enum[])this.enumClass.getEnumConstants())[i]).method_15434());
        }
        return builder.toString();
    }

    @Override
    public T read(String configValue) {
        for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
            if (!((class_3542)value).method_15434().equalsIgnoreCase(configValue)) continue;
            return (T)value;
        }
        throw new IllegalArgumentException("Unknown value '%s'".formatted(configValue));
    }

    @Override
    public String write(T c) {
        return ((class_3542)c).method_15434();
    }

    @Override
    protected Codec<T> valueCodec() {
        return class_3542.method_53955(this.enumClass::getEnumConstants);
    }

    @Override
    public class_9139<ByteBuf, T> valueStreamCodec() {
        return class_9135.method_56375(i -> ((Enum[])this.enumClass.getEnumConstants())[i], (ToIntFunction)class_156.method_43658(Arrays.asList((Enum[])this.enumClass.getEnumConstants())));
    }

    public class_2561 getAsComponent(T value) {
        return this.toText.apply(value);
    }

    @Override
    public ConfigEntries.ConfigEntryFactory<T> getConfigEntryFactory() {
        return ConfigEntries.enumConfigEntryFactory(this);
    }
}

