/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config.value.type;

import artifacts.config.value.type.ValueType;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9139;

public abstract class NumberValueType<T extends Number>
extends ValueType<T, Number> {
    private final T min;
    private final T max;
    private final Codec<T> valueCodec;
    private final class_9139<ByteBuf, T> valueStreamCodec;

    public NumberValueType(T min, T max, Codec<T> valueCodec, class_9139<ByteBuf, T> valueStreamCodec) {
        this.min = min;
        this.max = max;
        this.valueCodec = valueCodec;
        this.valueStreamCodec = valueStreamCodec;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    protected Codec<T> valueCodec() {
        return this.valueCodec;
    }

    @Override
    public class_9139<ByteBuf, T> valueStreamCodec() {
        return this.valueStreamCodec;
    }

    @Override
    public boolean isCorrect(T value) {
        return ((Comparable)value).compareTo(this.min) >= 0 && ((Comparable)value).compareTo(this.max) <= 0;
    }

    @Override
    public String makeError(T value) {
        if (((Number)this.min).doubleValue() == 0.0 && ((Number)this.max).intValue() == Integer.MAX_VALUE) {
            return "Value must be non-negative: %s".formatted(value);
        }
        return "Value must be within range [%s;%s]: %s".formatted(this.min, this.max, value);
    }

    @Override
    public String getAllowedValuesComment() {
        return "Range: %s ~ %s".formatted(this.getMin(), this.getMax()).replace("0.0 ~ Infinity", "> 0.0").replace("0 ~ 2147483647", "> 0");
    }

    @Override
    public T write(T value) {
        return value;
    }
}

