/*
 * Decompiled with CFR 0.152.
 */
package artifacts.event;

import artifacts.attribute.DynamicAttributeModifier;
import artifacts.component.SwimData;
import artifacts.component.ability.PostDamageCooldown;
import artifacts.component.ability.TickingAbility;
import artifacts.component.ability.mobeffect.AttackEffects;
import artifacts.component.ability.mobeffect.PostDamageEffects;
import artifacts.equipment.EquipmentHelper;
import artifacts.extensions.ability.LivingEntityExtensions;
import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.MobAccessor;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModTags;
import artifacts.util.DamageSourceHelper;
import be.florens.expandability.api.EventResult;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_4174;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class ArtifactHooks {
    public static void livingUpdate(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SwimData swimData = PlatformServices.platformHelper.getSwimData(entity);
            if (swimData != null) {
                swimData.update(player);
            }
        }
        ArtifactHooks.onItemTick(entity);
        DynamicAttributeModifier.tickModifiers(entity);
        if (!entity.method_24828()) {
            UmbrellaItem.onLivingUpdate(entity);
        }
    }

    public static void onLivingDamaged(class_1309 entity, class_1282 source, float amount) {
        ArtifactHooks.absorbDamage(entity, source, amount);
        PostDamageEffects.onLivingDamaged(entity, source);
        PostDamageCooldown.onLivingDamaged(entity, source);
    }

    public static void onItemChanged(class_1309 entity, class_1799 oldStack, class_1799 newStack) {
        boolean isDisabled;
        if (entity.method_37908().method_8608() || oldStack == newStack) {
            return;
        }
        boolean wasDisabled = oldStack.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get());
        boolean wasToggledOff = wasDisabled ^ (isDisabled = newStack.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get())) && isDisabled;
        for (Supplier<? extends class_9331<? extends TickingAbility>> type : ModDataComponents.TICKING_COMPONENTS) {
            TickingAbility oldAbility = (TickingAbility)oldStack.method_57824(type.get());
            if (oldAbility == null || !oldAbility.isNonCosmetic() || !wasToggledOff && oldAbility.equals(newStack.method_57824(type.get()))) continue;
            oldAbility.onUnequip(entity);
        }
        ArtifactHooks.refreshTickingAbilities(entity);
    }

    public static void refreshTickingAbilities(class_1309 entity) {
        boolean shouldTick = EquipmentHelper.reduceEquipment(entity, false, (stack, hasTickingAbilities) -> {
            for (Supplier<? extends class_9331<? extends TickingAbility>> type : ModDataComponents.TICKING_COMPONENTS) {
                if (!stack.method_57826(type.get())) continue;
                return true;
            }
            return hasTickingAbilities;
        });
        ((LivingEntityExtensions)entity).artifacts$setTickingAbilities(shouldTick);
    }

    public static void onItemTick(class_1309 entity) {
        if (!(entity instanceof class_1657) && !((LivingEntityExtensions)entity).artifacts$hasTickingAbilities()) {
            return;
        }
        for (Supplier<? extends class_9331<? extends TickingAbility>> type : ModDataComponents.TICKING_COMPONENTS) {
            EquipmentHelper.iterateAbilities(type.get(), entity, false, false, (ability, stack) -> {
                class_1657 player;
                boolean isOnCooldown = entity instanceof class_1657 && (player = (class_1657)entity).method_7357().method_7904(stack.method_7909());
                ability.wornTick(entity, isOnCooldown, stack.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get()));
            });
        }
    }

    public static void onAttackBurningLivingHurt(class_1309 entity, class_1282 damageSource) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.method_5753()) {
            int duration = (int)attacker.method_45325(ModAttributes.ATTACK_BURNING_DURATION);
            entity.method_5639((float)duration);
        }
    }

    public static void doPostAttackEffects(class_1309 entity, class_1282 damageSource) {
        EquipmentHelper.iterateAbilities(ModDataComponents.RETALIATION_EFFECTS.get(), entity, true, true, (ability, stack) -> ability.onLivingHurt(entity, (class_1799)stack, damageSource));
        AttackEffects.onLivingHurt(entity, damageSource);
        ArtifactHooks.onAttackBurningLivingHurt(entity, damageSource);
    }

    public static void onEntityAdded(class_1297 entity) {
        class_1314 creeper;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            ArtifactHooks.refreshTickingAbilities(livingEntity);
        }
        if (entity instanceof class_1314 && (creeper = (class_1314)entity).method_5864().method_20210(ModTags.CREEPERS)) {
            Predicate<class_1309> predicate = target -> EquipmentHelper.hasAbilityActive(ModDataComponents.CREEPER_REPELLENT.get(), target, true);
            ((MobAccessor)creeper).getGoalSelector().method_6277(3, (class_1352)new class_1338(creeper, class_1657.class, predicate, 6.0f, 1.0, 1.3, class_1301.field_6156::test));
        }
    }

    public static void onPlaySoundAtEntity(class_1309 entity, float volume, float pitch) {
        EquipmentHelper.iterateComponents(ModDataComponents.HURT_SOUND.get(), entity, (stack, ability) -> {
            if (((Boolean)ability.enabled().get()).booleanValue()) {
                entity.method_5783((class_3414)ability.soundEvent().comp_349(), volume, pitch);
            }
        });
    }

    public static class_1799 applySmeltOresAbility(class_1799 original, @Nullable class_1297 entity, @Nullable class_2680 state, Consumer<Integer> experienceConsumer) {
        if (entity instanceof class_1309) {
            class_1799 smeltingResult;
            Optional recipe;
            class_1309 livingEntity = (class_1309)entity;
            if (EquipmentHelper.hasAbilityActive(ModDataComponents.AUTO_SMELT.get(), livingEntity, true) && state != null && state.method_26164(ModTags.ORES) && original.method_31573(ModTags.RAW_MATERIALS) && (recipe = livingEntity.method_37908().method_8433().method_8132(class_3956.field_17546, (class_9695)new class_9696(original), livingEntity.method_37908())).isPresent() && !(smeltingResult = ((class_3861)((class_8786)recipe.get()).comp_1933()).method_8110((class_7225.class_7874)livingEntity.method_37908().method_30349())).method_7960()) {
                experienceConsumer.accept(ArtifactHooks.getExperience(((class_3861)((class_8786)recipe.get()).comp_1933()).method_8171()));
                return smeltingResult.method_46651(smeltingResult.method_7947() * original.method_7947());
            }
        }
        return original;
    }

    private static int getExperience(float experience) {
        int amount = class_3532.method_15375((float)experience);
        if (Math.random() < (double)class_3532.method_22450((float)experience)) {
            ++amount;
        }
        return amount;
    }

    public static int modifyUseDuration(int originalDuration, class_1799 item, class_1309 entity) {
        if (originalDuration <= 0) {
            return originalDuration;
        }
        if (item.method_7976() == class_1839.field_8950) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.method_45325(ModAttributes.EATING_SPEED)));
        }
        if (item.method_7976() == class_1839.field_8946) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.method_45325(ModAttributes.DRINKING_SPEED)));
        }
        return originalDuration;
    }

    public static int modifyExperience(int originalXp, class_1309 entity, class_1657 attacker) {
        if (attacker == null || entity instanceof class_1657 || originalXp <= 0) {
            return originalXp;
        }
        double multiplier = attacker.method_45325(ModAttributes.ENTITY_EXPERIENCE);
        int droppedXp = (int)Math.round((double)originalXp * multiplier);
        return Math.max(0, droppedXp);
    }

    public static void absorbDamage(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource)) {
            EquipmentHelper.iterateAbilities(ModDataComponents.DAMAGE_ABSORPTION.get(), attacker, true, true, (ability, stack) -> {
                float damageDealt;
                double absorptionRatio = (Double)ability.absorptionRatio().get();
                double maxHealthAbsorbed = ((Integer)ability.maxDamageAbsorbed().get()).intValue();
                float damageAbsorbed = (float)Math.min(maxHealthAbsorbed, absorptionRatio * (double)(damageDealt = Math.min(amount, entity.method_6032())));
                if (damageAbsorbed > 0.0f && (Double)ability.absorptionChance().get() > entity.method_59922().method_43058()) {
                    attacker.method_6025(damageAbsorbed);
                }
            });
        }
    }

    public static float getModifiedFriction(float friction, class_1309 entity, class_2248 block) {
        if (friction > 0.6f && ModTags.isInTag(block, class_3481.field_15467)) {
            double slipperinessReduction = entity.method_45325(ModAttributes.SLIP_RESISTANCE);
            return class_3532.method_16439((float)((float)slipperinessReduction), (float)friction, (float)0.6f);
        }
        return friction;
    }

    public static void applyBoneMealAfterEating(class_1309 entity, class_4174 properties) {
        if (!entity.method_37908().method_8608() && EquipmentHelper.hasAbilityActive(ModDataComponents.POST_EATING_PLANT_GROWTH.get(), entity, true) && properties.comp_2491() > 0 && !properties.comp_2493() && entity.method_24828() && entity.method_25936().method_26164(ModTags.ROOTED_BOOTS_GRASS)) {
            class_1752.method_7720((class_1799)new class_1799((class_1935)class_1802.field_8324), (class_1937)entity.method_37908(), (class_2338)entity.method_23312());
        }
    }

    public static EventResult onPlayerSwim(class_1657 player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData != null) {
            if (swimData.isSwimming()) {
                return EventResult.SUCCESS;
            }
            if (EquipmentHelper.hasAbilityActive(ModDataComponents.SINKING.get(), (class_1309)player, true)) {
                return EventResult.FAIL;
            }
        }
        return EventResult.PASS;
    }

    public static boolean onFluidCollision(class_1309 entity, class_3610 fluidState) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData(entity);
        if (swimData == null || swimData.isWet() || swimData.isSwimming()) {
            return false;
        }
        return EquipmentHelper.hasAbilityActive(ModDataComponents.FLUID_COLLISION.get(), entity, true, ability -> ability.matchesFluid(fluidState) && ability.condition().test(entity));
    }
}

