/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import artifacts.component.ability.AttributeModifiers;
import artifacts.component.ability.EnchantmentLevelModifiers;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.SimpleAbility;
import artifacts.component.ability.mobeffect.EquipmentMobEffects;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class WearableArtifactItem
extends class_1792 {
    public WearableArtifactItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        if (Artifacts.CONFIG.client.showTooltips.get().booleanValue() && !PlatformServices.platformHelper.isModLoaded("curios") && !PlatformServices.platformHelper.isModLoaded("trinkets") && !PlatformServices.platformHelper.isModLoaded("accessories")) {
            list.add((class_2561)class_2561.method_43471((String)"%s.tooltip.missing_dependency".formatted("artifacts")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        } else {
            super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        }
    }

    public static class Builder {
        private final String itemName;
        private final class_1792.class_1793 properties = new class_1792.class_1793();
        private final List<AttributeModifiers.Entry> attributes = new ArrayList<AttributeModifiers.Entry>();
        private final List<EnchantmentLevelModifiers.Entry> enchantments = new ArrayList<EnchantmentLevelModifiers.Entry>();

        public Builder(String itemName) {
            this.itemName = itemName;
            this.equipSound((class_6880<class_3414>)class_3417.field_14883);
        }

        public Builder equipSound(class_3414 equipSound) {
            return this.equipSound((class_6880<class_3414>)class_7923.field_41172.method_47983((Object)equipSound));
        }

        public Builder equipSound(class_6880<class_3414> equipSound) {
            this.properties.method_57349(ModDataComponents.EQUIP_SOUND.get(), (Object)((class_3414)equipSound.comp_349()));
            return this;
        }

        public Builder addAttributeModifier(class_6880<class_1320> attribute, Value<Double> amount, class_1322.class_1323 operation) {
            return this.addAttributeModifier(attribute, amount, operation, true);
        }

        public Builder addAttributeModifier(class_6880<class_1320> attribute, Value<Double> amount, class_1322.class_1323 operation, boolean ignoreCooldown) {
            this.attributes.add(new AttributeModifiers.Entry(attribute, amount, operation, Artifacts.id(this.itemName + "/" + ((class_5321)attribute.method_40230().orElseThrow()).method_29177().method_12832()), ignoreCooldown));
            return this;
        }

        public Builder mobEffect(class_6880<class_1291> effect, Value<Integer> level, Value<Integer> duration, EntityCondition condition) {
            return this.component(ModDataComponents.MOB_EFFECTS.get(), new EquipmentMobEffects(List.of(new EquipmentMobEffects.Entry(new MobEffectProvider(effect, level, duration, Value.of(false), Value.of(true), condition)))));
        }

        public Builder increasesEnchantment(class_5321<class_1887> enchantment, Value<Integer> amount) {
            this.enchantments.add(new EnchantmentLevelModifiers.Entry(enchantment, amount));
            return this;
        }

        public Builder component(class_9331<class_3902> type) {
            return this.component(type, class_3902.field_17274);
        }

        public Builder component(class_9331<SimpleAbility> type, Value<Boolean> enabled) {
            return this.component(type, new SimpleAbility(enabled));
        }

        public <T> Builder component(class_9331<T> type, T component) {
            this.properties.method_57349(type, component);
            return this;
        }

        public Builder properties(Consumer<class_1792.class_1793> consumer) {
            consumer.accept(this.properties);
            return this;
        }

        public WearableArtifactItem build() {
            this.properties.method_7889(1).method_7894(class_1814.field_8903).method_24359();
            if (!this.attributes.isEmpty()) {
                this.properties.method_57349(ModDataComponents.ATTRIBUTE_MODIFIERS.get(), (Object)new AttributeModifiers(this.attributes));
            }
            if (!this.enchantments.isEmpty()) {
                this.properties.method_57349(ModDataComponents.ENCHANTMENT_LEVEL_MODIFIERS.get(), (Object)new EnchantmentLevelModifiers(this.enchantments));
            }
            return new WearableArtifactItem(this.properties);
        }
    }
}

