/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.network.ChorusTotemUsedPacket;
import artifacts.network.DoubleJumpPacket;
import artifacts.network.PlaySoundAtPlayerPacket;
import artifacts.network.SwimPacket;
import artifacts.network.ToggleKeyPressedPacket;
import artifacts.network.UpdateItemConfigPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NetworkHandler {
    public static final List<PayloadHandler<?>> SERVERBOUND_HANDLERS = new ArrayList();
    public static final List<PayloadHandler<?>> CLIENTBOUND_HANDLERS = new ArrayList();

    public static void initPayloads() {
        NetworkHandler.registerClientbound(ChorusTotemUsedPacket.TYPE, ChorusTotemUsedPacket.CODEC, ChorusTotemUsedPacket::apply);
        NetworkHandler.registerClientbound(PlaySoundAtPlayerPacket.TYPE, PlaySoundAtPlayerPacket.CODEC, PlaySoundAtPlayerPacket::apply);
        NetworkHandler.registerClientbound(UpdateItemConfigPacket.TYPE, UpdateItemConfigPacket.CODEC, UpdateItemConfigPacket::apply);
        NetworkHandler.registerClientbound(SwimPacket.TYPE, SwimPacket.CODEC, SwimPacket::apply);
        NetworkHandler.registerServerbound(DoubleJumpPacket.TYPE, DoubleJumpPacket.CODEC, DoubleJumpPacket::apply);
        NetworkHandler.registerServerbound(SwimPacket.TYPE, SwimPacket.CODEC, SwimPacket::apply);
        NetworkHandler.registerServerbound(ToggleKeyPressedPacket.TYPE, ToggleKeyPressedPacket.CODEC, ToggleKeyPressedPacket::apply);
    }

    private static <T extends class_8710> void registerServerbound(class_8710.class_9154<T> type, class_9139<? super class_9129, T> codec, Receiver<T> receiver) {
        SERVERBOUND_HANDLERS.add(new PayloadHandler<T>(type, codec, receiver));
    }

    private static <T extends class_8710> void registerClientbound(class_8710.class_9154<T> type, class_9139<? super class_9129, T> codec, Receiver<T> receiver) {
        CLIENTBOUND_HANDLERS.add(new PayloadHandler<T>(type, codec, receiver));
    }

    public static void sendToServer(class_8710 payload) {
        class_634 listener = Objects.requireNonNull(class_310.method_1551().method_1562());
        listener.method_52787((class_2596)new class_2817(payload));
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_8710 payload) {
        for (class_3222 player : players) {
            NetworkHandler.sendToPlayer(player, payload);
        }
    }

    public static void sendToPlayer(class_3222 player, class_8710 payload) {
        player.field_13987.method_14364((class_2596)new class_2658(payload));
    }

    @FunctionalInterface
    public static interface Receiver<T extends class_8710> {
        public void receive(T var1, PayloadContext var2);
    }

    public record PayloadHandler<T extends class_8710>(class_8710.class_9154<T> type, class_9139<? super class_9129, T> codec, Receiver<T> receiver) {
    }

    public static interface PayloadContext {
        public class_1657 player();

        public void queue(Runnable var1);
    }
}

