/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.Artifacts;
import artifacts.platform.PlatformServices;
import artifacts.registry.RegistryHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public abstract class Register<R>
implements Iterable<R> {
    private final class_5321<class_2378<R>> registry;
    private final List<RegistryHolder<R, ?>> entries = new ArrayList();

    public Register(class_5321<class_2378<R>> registry) {
        this.registry = registry;
    }

    public static <R> Register<R> create(class_5321<class_2378<R>> registry) {
        return PlatformServices.platformHelper.createRegister(registry);
    }

    public class_5321<class_2378<R>> getRegistry() {
        return this.registry;
    }

    public Collection<RegistryHolder<R, ?>> getEntries() {
        return this.entries;
    }

    public <T extends R> RegistryHolder<R, T> register(String name, Supplier<T> supplier) {
        RegistryHolder<R, T> holder = new RegistryHolder<R, T>(Artifacts.key(this.registry, name), supplier);
        this.entries.add(holder);
        if (this.getRegistry().equals((Object)class_7924.field_41251) || this.getRegistry().equals((Object)class_7924.field_41208) || this.getRegistry().equals((Object)class_7924.field_49659)) {
            this.bind(holder);
        }
        return holder;
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return this.entries.stream().map(RegistryHolder::comp_349).iterator();
    }

    public void register() {
        if (!(this.getRegistry().equals((Object)class_7924.field_41251) || this.getRegistry().equals((Object)class_7924.field_41208) || this.getRegistry().equals((Object)class_7924.field_49659))) {
            for (RegistryHolder<R, ?> holder : this.getEntries()) {
                this.bind(holder);
            }
        }
    }

    protected abstract <T extends R> void bind(RegistryHolder<R, T> var1);
}

