/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModTags;
import artifacts.world.CampsiteFeatureConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3708;
import net.minecraft.class_3865;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8934;

public class CampsiteFeature
extends class_3031<CampsiteFeatureConfiguration> {
    public static final class_5321<class_52> CHEST_LOOT = Artifacts.key(class_7924.field_50079, "chests/campsite_chest");
    public static final class_5321<class_52> BARREL_LOOT = Artifacts.key(class_7924.field_50079, "chests/campsite_barrel");

    public CampsiteFeature() {
        super(CampsiteFeatureConfiguration.CODEC);
    }

    public boolean method_13151(class_5821<CampsiteFeatureConfiguration> context) {
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        CampsiteFeatureConfiguration config = (CampsiteFeatureConfiguration)context.method_33656();
        if (!this.isSufficientlyFlat(level, origin)) {
            return false;
        }
        class_2338.method_20437((class_2338)origin.method_10069(-2, 0, -2), (class_2338)origin.method_10069(2, 2, 2)).filter(pos -> Math.abs(pos.method_10263() - origin.method_10263()) < 2 || Math.abs(pos.method_10260() - origin.method_10260()) < 2).filter(pos -> !level.method_8320(pos).method_26215()).forEach(pos -> this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_10543.method_9564()));
        this.placeFloor(config, level, origin, random);
        this.placeCampfire(config, level, origin, random);
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 pos2 = origin.method_10079(direction, 2);
        if (random.method_43048(3) == 0) {
            class_2338.method_20437((class_2338)pos2.method_10093(direction.method_10170()), (class_2338)pos2.method_10093(direction.method_10160())).forEach(barrelPos -> {
                this.placeBarrel(level, (class_2338)barrelPos, random);
                if (random.method_43048(3) == 0) {
                    this.placeBarrel(level, barrelPos.method_10084(), random);
                }
            });
        } else {
            class_2350 bedDirection = random.method_43056() ? direction.method_10170() : direction.method_10160();
            class_2680 bedBlock = (class_2680)config.beds().method_23455(random, pos2).method_11657((class_2769)class_2244.field_11177, (Comparable)bedDirection);
            this.method_13153((class_1945)level, pos2, (class_2680)bedBlock.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560));
            this.method_13153((class_1945)level, pos2.method_10093(bedDirection.method_10153()), (class_2680)bedBlock.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557));
            this.placeBarrel(level, pos2.method_10093(bedDirection), random);
            this.placeLightSource(config, level, pos2.method_10093(bedDirection).method_10084(), random);
        }
        direction = random.method_43056() ? direction.method_10170() : direction.method_10160();
        pos2 = origin.method_10079(direction, 2);
        List positions = class_2338.method_20437((class_2338)pos2.method_10093(direction.method_10170()), (class_2338)pos2.method_10093(direction.method_10160())).map(class_2338::method_10062).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(positions);
        this.placeCraftingStation(config, level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        this.placeFurnace(config, level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        this.placeChest(level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        return true;
    }

    private boolean isSufficientlyFlat(class_5281 level, class_2338 origin) {
        return class_2338.method_20437((class_2338)origin.method_10069(-2, 0, -2), (class_2338)origin.method_10069(2, 0, 2)).filter(pos -> level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036)).filter(pos -> level.method_8320(pos).method_26215()).count() >= 6L;
    }

    private void placeFloor(CampsiteFeatureConfiguration config, class_5281 level, class_2338 origin, class_5819 random) {
        class_2338.method_20437((class_2338)origin.method_10069(-2, -1, -2), (class_2338)origin.method_10069(2, -1, 2)).filter(pos -> Math.abs(pos.method_10263() - origin.method_10263()) < 2 || Math.abs(pos.method_10260() - origin.method_10260()) < 2).forEach(pos -> {
            if (!level.method_8320(pos).method_26206((class_1922)level, pos, class_2350.field_11036)) {
                this.method_13153((class_1945)level, (class_2338)pos, config.floor().method_23455(random, pos));
            } else if (random.method_43056()) {
                if (level.method_8320(pos).method_27852(class_2246.field_28888)) {
                    this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_29031.method_9564());
                } else if (level.method_8320(pos).method_27852(class_2246.field_10340)) {
                    this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_10445.method_9564());
                }
            }
        });
    }

    private void placeCampfire(CampsiteFeatureConfiguration config, class_5281 level, class_2338 origin, class_5819 random) {
        class_2680 campfire = config.unlitCampfires().method_23455(random, origin);
        if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.method_43057() < 0.1) {
            campfire = config.litCampfires().method_23455(random, origin);
        }
        this.method_13153((class_1945)level, origin, campfire);
    }

    private void placeLightSource(CampsiteFeatureConfiguration config, class_5281 level, class_2338 pos, class_5819 random) {
        if ((double)random.method_43057() < 0.5) {
            class_2680 lightSource = config.unlitLightSources().method_23455(random, pos);
            if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.method_43057() < 0.3) {
                lightSource = config.lightSources().method_23455(random, pos);
            }
            this.method_13153((class_1945)level, pos, lightSource);
        }
    }

    private void placeCraftingStation(CampsiteFeatureConfiguration config, class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        class_2680 craftingStation = config.craftingStations().method_23455(random, pos);
        if (craftingStation.method_28498((class_2769)class_2741.field_12481)) {
            craftingStation = (class_2680)craftingStation.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
        }
        this.method_13153((class_1945)level, pos, craftingStation);
        if (random.method_43048(3) == 0) {
            this.method_13153((class_1945)level, pos.method_10084(), config.decorations().method_23455(random, pos));
        }
    }

    private void placeFurnace(CampsiteFeatureConfiguration config, class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        class_2680 furnace = config.furnaces().method_23455(random, pos);
        furnace = (class_2680)furnace.method_11657((class_2769)class_3865.field_11104, (Comparable)facing);
        this.method_13153((class_1945)level, pos, furnace);
        if (random.method_43056()) {
            this.method_13153((class_1945)level, pos.method_10084(), config.furnaceChimneys().method_23455(random, pos));
        }
    }

    private void placeBarrel(class_5281 level, class_2338 pos, class_5819 random) {
        class_2680 barrel = class_2246.field_16328.method_9564();
        barrel = random.method_43056() ? (class_2680)barrel.method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.field_11036) : (class_2680)barrel.method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.class_2353.field_11062.method_10183(random));
        this.method_13153((class_1945)level, pos, barrel);
        class_8934.method_54868((class_1922)level, (class_5819)random, (class_2338)pos, BARREL_LOOT);
    }

    public void placeChest(class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        if ((double)random.method_43057() < Artifacts.CONFIG.general.campsite.mimicChance.get()) {
            MimicEntity mimic = (MimicEntity)ModEntityTypes.MIMIC.get().method_5883((class_1937)level.method_8410());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                level.method_8649((class_1297)mimic);
            }
        } else {
            class_2680 chest;
            if (random.method_43048(8) == 0) {
                this.method_13153((class_1945)level, pos.method_10074(), class_2246.field_10375.method_9564());
                chest = class_2246.field_10380.method_9564();
                this.method_13153((class_1945)level, pos, (class_2680)class_2246.field_10380.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.class_2353.field_11062.method_10183(random)));
            } else {
                chest = Artifacts.CONFIG.general.campsite.useModdedChests.get() != false ? ModTags.getTag(ModTags.CAMPSITE_CHESTS).method_40243(random).map(class_6880::comp_349).orElse(class_2246.field_10034).method_9564() : class_2246.field_10034.method_9564();
            }
            if (chest.method_28498((class_2769)class_2741.field_12481)) {
                chest = (class_2680)chest.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            }
            this.method_13153((class_1945)level, pos, chest);
            class_8934.method_54868((class_1922)level, (class_5819)random, (class_2338)pos, CHEST_LOOT);
        }
    }
}

