/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record EnchantmentLevelModifiers(List<Entry> entries) implements CompositeAbility<Entry>
{
    public static final List<class_5321<class_1887>> ALLOWED_ENCHANTMENTS = List.of(class_1893.field_9130, class_1893.field_9110, class_1893.field_9100, class_1893.field_9114);
    public static final Codec<EnchantmentLevelModifiers> CODEC = CompositeAbility.codec(Entry.CODEC, EnchantmentLevelModifiers::new, EnchantmentLevelModifiers::entries);
    public static final class_9139<class_9129, EnchantmentLevelModifiers> STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, EnchantmentLevelModifiers::new, EnchantmentLevelModifiers::entries);

    public record Entry(class_5321<class_1887> enchantment, Value<Integer> amount) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41265).validate(enchantment -> ALLOWED_ENCHANTMENTS.contains(enchantment) ? DataResult.success((Object)enchantment) : DataResult.error(() -> "Unsupported enchantment: %s".formatted(enchantment.method_29177()))).fieldOf("enchantment").forGetter(Entry::enchantment), (App)ValueTypes.ENCHANTMENT_LEVEL.codec().optionalFieldOf("level", Value.of(1)).forGetter(Entry::amount)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56435((class_9139)class_5321.method_56038((class_5321)class_7924.field_41265), Entry::enchantment, ValueTypes.ENCHANTMENT_LEVEL.streamCodec(), Entry::amount, Entry::new);

        @Override
        public boolean isNonCosmetic() {
            return (Integer)this.amount.get() > 0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            String enchantmentName = this.enchantment().method_29177().method_12832();
            if ((Integer)this.amount().get() == 1) {
                writer.add("%s.single_level".formatted(enchantmentName), new Object[0]);
            } else {
                writer.add("%s.multiple_levels".formatted(enchantmentName), this.amount().get());
            }
        }
    }
}

