/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PostDamageEffects(List<Entry> entries) implements CompositeAbility<Entry>
{
    public static final Codec<PostDamageEffects> CODEC = Entry.CODEC.listOf(0, 16).xmap(PostDamageEffects::new, PostDamageEffects::entries);
    public static final class_9139<class_9129, PostDamageEffects> STREAM_CODEC = class_9135.method_56363().apply(Entry.STREAM_CODEC).method_56432(PostDamageEffects::new, PostDamageEffects::entries);

    public static void onLivingDamaged(class_1309 entity, class_1282 damageSource) {
        if (!entity.method_37908().method_8608()) {
            EquipmentHelper.iterateAbilities(ModDataComponents.POST_DAMAGE_EFFECTS.get(), entity, true, true, (ability, stack) -> {
                for (Entry entry : ability.entries) {
                    if (!entry.shouldApply(damageSource.method_48792(), entity)) continue;
                    entity.method_6092(entry.provider.createEffect());
                }
            });
        }
    }

    public record Entry(MobEffectProvider provider, Optional<class_6862<class_8110>> tag, Value<Double> chance) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectProvider.codec(true).fieldOf("effect").forGetter(Entry::provider), (App)class_6862.method_40090((class_5321)class_7924.field_42534).optionalFieldOf("tag").forGetter(Entry::tag), (App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(Entry::chance)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56436(MobEffectProvider.STREAM_CODEC, Entry::provider, (class_9139)class_9135.method_56382(ModCodecs.tagKeyStreamCodec(class_7924.field_42534)), Entry::tag, ValueTypes.FRACTION.streamCodec(), Entry::chance, Entry::new);

        public boolean shouldApply(class_8110 type, class_1309 entity) {
            return this.provider.canApply(entity) && entity.method_59922().method_43058() < (Double)this.chance.get() && (this.tag.isEmpty() || (Boolean)entity.method_37908().method_30349().method_33310(class_7924.field_42534).flatMap(registry -> registry.method_40266(this.tag.get()).map(tag -> tag.method_40241(registry.method_47983((Object)type)))).orElseThrow() != false);
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider.isNonCosmetic() && (Double)this.chance.get() > 0.0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            if (this.provider.mobEffect().equals((Object)class_1294.field_5918) && this.tag.isPresent() && this.tag.get().equals((Object)class_8103.field_42246) && (Double)this.chance.get() == 1.0) {
                writer.add("fire_resistance", new Object[0]);
            } else if (this.provider.mobEffect().equals((Object)class_1294.field_5904) && this.tag.isEmpty() && (Double)this.chance.get() == 1.0) {
                writer.add("speed", new Object[0]);
            }
        }
    }
}

