/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class NecklaceModel
extends HumanoidModel<LivingEntity> {
    public NecklaceModel(ModelPart part) {
        super(part, RenderType::entityTranslucent);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, int color) {
        poseStack.pushPose();
        if (this.young) {
            float babyBodyScale = 2.0f;
            float scale = 1.0f / babyBodyScale;
            poseStack.scale(scale, scale, scale);
            float bodyYOffset = 24.0f;
            poseStack.translate(0.0f, bodyYOffset / 16.0f, 0.0f);
        }
        poseStack.scale(0.51f, 0.51f, 0.51f);
        this.bodyParts().forEach(modelPart -> modelPart.render(poseStack, buffer, light, overlay, color));
        poseStack.popPose();
    }

    public static MeshDefinition createNecklace(CubeListBuilder body) {
        MeshDefinition mesh = NecklaceModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("body", body.texOffs(0, 0).addBox(-8.0f, -0.5f, -4.5f, 16.0f, 25.0f, 9.0f), PartPose.ZERO);
        return mesh;
    }

    public static MeshDefinition createCenteredNecklace(CubeListBuilder body) {
        MeshDefinition mesh = NecklaceModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("body", body.texOffs(0, 0).addBox(-8.5f, -0.5f, -4.5f, 17.0f, 25.0f, 9.0f), PartPose.ZERO);
        return mesh;
    }

    public static MeshDefinition createCharmOfSinking() {
        CubeListBuilder body = CubeListBuilder.create();
        body.texOffs(50, 0);
        body.addBox(-1.0f, 3.5f, -5.0f, 2.0f, 4.0f, 1.0f);
        return NecklaceModel.createNecklace(body);
    }

    public static MeshDefinition createCrossNecklace() {
        CubeListBuilder body = CubeListBuilder.create();
        body.texOffs(52, 0);
        body.addBox(-0.5f, 4.5f, -5.0f, 1.0f, 4.0f, 1.0f);
        body.texOffs(56, 0);
        body.addBox(-1.5f, 5.5f, -5.0f, 3.0f, 1.0f, 1.0f);
        return NecklaceModel.createCenteredNecklace(body);
    }

    public static MeshDefinition createPanicNecklace() {
        CubeListBuilder body = CubeListBuilder.create();
        body.texOffs(52, 0);
        body.addBox(-2.5f, 5.5f, -5.0f, 2.0f, 2.0f, 1.0f);
        body.texOffs(58, 0);
        body.addBox(0.5f, 5.5f, -5.0f, 2.0f, 2.0f, 1.0f);
        body.texOffs(52, 3);
        body.addBox(-1.5f, 6.5f, -5.0f, 3.0f, 2.0f, 1.0f);
        body.texOffs(60, 4);
        body.addBox(-0.5f, 8.5f, -5.0f, 1.0f, 1.0f, 1.0f);
        return NecklaceModel.createCenteredNecklace(body);
    }

    public static MeshDefinition createCharmOfShrinking() {
        CubeListBuilder body = CubeListBuilder.create();
        body.texOffs(52, 0);
        body.addBox(-1.5f, 4.5f, -5.0f, 3.0f, 2.0f, 1.0f);
        body.texOffs(52, 3);
        body.addBox(-0.5f, 6.5f, -5.0f, 1.0f, 1.0f, 1.0f);
        return NecklaceModel.createCenteredNecklace(body);
    }

    public static MeshDefinition createPendant() {
        CubeListBuilder body = CubeListBuilder.create();
        body.texOffs(50, 0);
        body.addBox(-1.0f, 4.5f, -5.0f, 2.0f, 2.0f, 1.0f);
        return NecklaceModel.createNecklace(body);
    }
}

