/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.retaliation.RetaliationEffect;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class FireEffect
extends RetaliationEffect {
    public static final Codec<FireEffect> CODEC = RecordCodecBuilder.create(instance -> FireEffect.codecStart(instance).and((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(FireEffect::fireDuration)).and((App)ValueTypes.BOOLEAN.codec().optionalFieldOf("grant_fire_resistance", Value.of(true)).forGetter(FireEffect::grantsFireResistance)).apply((Applicative)instance, FireEffect::new));
    public static final StreamCodec<ByteBuf, FireEffect> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationEffect::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationEffect::cooldown, ValueTypes.DURATION.streamCodec(), FireEffect::fireDuration, ValueTypes.BOOLEAN.streamCodec(), FireEffect::grantsFireResistance, FireEffect::new);
    private final Value<Integer> fireDuration;
    private final Value<Boolean> grantsFireResistance;

    public FireEffect(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> fireDuration, Value<Boolean> grantsFireResistance) {
        super("fire", strikeChance, cooldown);
        this.fireDuration = fireDuration;
        this.grantsFireResistance = grantsFireResistance;
    }

    public Value<Integer> fireDuration() {
        return this.fireDuration;
    }

    public Value<Boolean> grantsFireResistance() {
        return this.grantsFireResistance;
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.fireDuration().get() > 0;
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        if (!attacker.fireImmune() && attacker.attackable() && (Integer)this.fireDuration().get() > 0) {
            if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
                target.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, (Integer)this.fireDuration().get() * 20, 0, false, false, true));
            }
            attacker.igniteForSeconds((float)((Integer)this.fireDuration().get()).intValue());
        }
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        super.addToTooltip(writer);
        if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
            writer.add("fire.fire_resistance", new Object[0]);
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FireEffect)) {
            return false;
        }
        FireEffect that = (FireEffect)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.fireDuration.equals(that.fireDuration) && this.grantsFireResistance.equals(that.grantsFireResistance);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fireDuration.hashCode();
        result = 31 * result + this.grantsFireResistance.hashCode();
        return result;
    }
}

