/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.BlockList;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import fabric.ziyue.tjmetro.mod.block.base.IRailwaySign;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockRailwaySignTianjin
extends BlockRailwaySignBase {
    public BlockRailwaySignTianjin(int length, boolean isOdd) {
        super(Blocks.createDefaultBlockSettings((boolean)true, blockState -> 15), length, isOdd);
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return IRailwaySign.getStateForNeighborUpdate(state, direction, neighborState, BlockList.RAILWAY_SIGN_TIANJIN_MIDDLE.get());
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        IRailwaySign.onPlaced(world, pos, state, BlockList.RAILWAY_SIGN_TIANJIN_MIDDLE.get(), this.getMiddleLength());
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (IBlockExtension.isBlock(state, BlockList.RAILWAY_SIGN_TIANJIN_MIDDLE.get())) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0, (Direction)facing);
        }
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)((double)this.getXStart() - 0.5), (double)0.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0, (Direction)facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection((double)(this.getXStart() + 3), (double)0.0, (double)7.5, (double)(this.getXStart() + 4), (double)16.0, (double)8.5, (Direction)facing);
        return VoxelShapes.union((VoxelShape)main, (VoxelShape)pole);
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.RAILWAY_SIGN_TIANJIN_MIDDLE.get());
    }

    @Override
    public int getXStart() {
        switch (this.length % 4) {
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 0 : 8;
            }
            case 3: {
                return this.isOdd ? 12 : 4;
            }
        }
        return this.isOdd ? 8 : 0;
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.railway_sign_tianjin";
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == BlockList.RAILWAY_SIGN_TIANJIN_MIDDLE.get().data) {
            return null;
        }
        return new BlockEntity(this.length, this.isOdd, blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockRailwaySignBase.BlockEntityBase {
        public BlockEntity(int length, boolean isOdd, BlockPos pos, BlockState state) {
            super(BlockEntity.getType(length, isOdd), length, pos, state);
        }

        public static BlockEntityType<?> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? null : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_2_EVEN.get();
                }
                case 3: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_TIANJIN_3_ODD.get() : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_3_EVEN.get();
                }
                case 4: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_TIANJIN_4_ODD.get() : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_4_EVEN.get();
                }
                case 5: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_TIANJIN_5_ODD.get() : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_5_EVEN.get();
                }
                case 6: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_TIANJIN_6_ODD.get() : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_6_EVEN.get();
                }
                case 7: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_TIANJIN_7_ODD.get() : BlockEntityTypes.RAILWAY_SIGN_TIANJIN_7_EVEN.get();
                }
            }
            return null;
        }
    }
}

