/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.Registry;
import fabric.ziyue.tjmetro.mod.TianjinMetro;
import fabric.ziyue.tjmetro.mod.block.BlockRoadblock;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockEntityRenderable;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import fabric.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public class BlockRoadblockSign
extends BlockRoadblock
implements BlockWithEntity {
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(pos)));
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.roadblock_sign", (Object[])new Object[0]));
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockEntityRenderable {
        public final String CONTENT_ID = "content";
        public String content = "";

        public BlockEntity(BlockPos blockPos, BlockState state) {
            super(BlockEntityTypes.ROADBLOCK_SIGN.get(), blockPos, state, 0.0f, 0.535f);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.content = compoundTag.getString("content");
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putString("content", this.content);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(String content) {
            this.content = content;
            BlockPos pos = this.getPos2().offset(IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (DirectionProperty)DirectionHelper.FACING).rotateYClockwise());
            org.mtr.mapping.holder.BlockEntity blockEntity = this.getWorld2().getBlockEntity(pos);
            if (blockEntity.data instanceof BlockEntity) {
                BlockEntity entity = (BlockEntity)((Object)blockEntity.data);
                entity.content = this.content;
                entity.markDirty2();
            } else {
                TianjinMetro.LOGGER.error("RoadBlockSign.BlockEntity: Unable to set data for block entity at " + pos.toShortString());
            }
            this.markDirty2();
        }
    }
}

