/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block.base;

import fabric.ziyue.tjmetro.mod.Registry;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.InitClient;

public abstract class BlockCustomColorBase
extends BlockExtension
implements BlockWithEntity {
    public BlockCustomColorBase(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nonnull
    public String getTranslationKey2() {
        return super.getTranslationKey2().replace("block.tjmetro.custom_color_", "block.minecraft.");
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)"tooltip.tjmetro.custom_color", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(pos)));
    }

    public static class BlockEntityBase
    extends BlockEntityExtension {
        public final String COLOR_ID = "color";
        public int color = -1;

        public BlockEntityBase(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
            super(type, blockPos, blockState);
        }

        public int getDefaultColor(BlockPos pos) {
            return InitClient.getStationColor((BlockPos)pos);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.color = compoundTag.getInt("color");
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putInt("color", this.color);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(int color) {
            this.color = color;
            this.markDirty2();
        }
    }
}

