/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.item;

import fabric.ziyue.tjmetro.mod.block.BlockPSDTopTianjin;
import fabric.ziyue.tjmetro.mod.block.BlockPSDTopTianjinBMT;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagAPGTianjin;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagAPGTianjinBMT;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagAPGTianjinJinjing;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagAPGTianjinTRT;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagPSDTianjin;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagPSDTianjinBMT;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagPSDTianjinJinjing;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDAPGGlassBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemPSDAPGBase;

public class ItemPSDAPGTianjinBase
extends ItemExtension
implements IBlock {
    public final Block block;

    public ItemPSDAPGTianjinBase(BlockRegistryObject block, ItemSettings settings) {
        super(settings);
        this.block = block.get();
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        int horizontalBlocks = this.block.data instanceof BlockPSDAPGDoorBase ? 2 : 1;
        if (ItemPSDAPGBase.blocksNotReplaceable((ItemUsageContext)context, (int)horizontalBlocks, (int)(this.isAPG() ? 2 : 3), (Block)this.block)) {
            return ActionResult.FAIL;
        }
        World world = context.getWorld();
        Direction playerFacing = context.getPlayerFacing();
        BlockPos pos = context.getBlockPos().offset(context.getSide());
        for (int x = 0; x < horizontalBlocks; ++x) {
            BlockPos newPos = pos.offset(playerFacing.rotateYClockwise(), x);
            for (int y = 0; y < 2; ++y) {
                BlockState state = this.block.getDefaultState().with(new Property((class_2769)BlockPSDAPGBase.FACING.data), (Comparable)playerFacing.data).with(new Property((class_2769)ItemPSDAPGTianjinBase.HALF.data), (Comparable)(y == 1 ? IBlock.DoubleBlockHalf.UPPER : IBlock.DoubleBlockHalf.LOWER));
                if (this.block.data instanceof BlockPSDAPGDoorBase) {
                    BlockState neighborState = state.with(new Property((class_2769)ItemPSDAPGTianjinBase.SIDE.data), (Comparable)(x == 0 ? IBlock.EnumSide.LEFT : IBlock.EnumSide.RIGHT));
                    world.setBlockState(newPos.up(y), neighborState);
                    continue;
                }
                world.setBlockState(newPos.up(y), state.with(new Property((class_2769)ItemPSDAPGTianjinBase.SIDE_EXTENDED.data), (Comparable)IBlock.EnumSide.SINGLE));
            }
            if (this.block.data instanceof BlockFlagPSDTianjin) {
                world.setBlockState(newPos.up(2), BlockPSDTopTianjin.getActualState(WorldAccess.cast((HolderBase)world), newPos.up(2), this.block.data instanceof BlockFlagPSDTianjinJinjing).with(new Property((class_2769)BlockPSDTopTianjin.STYLE.data), (Comparable)((Object)BlockPSDTopTianjin.EnumPSDType.STATION_NAME)));
                continue;
            }
            if (!(this.block.data instanceof BlockFlagPSDTianjinBMT)) continue;
            world.setBlockState(newPos.up(2), BlockPSDTopTianjinBMT.getActualState(WorldAccess.cast((HolderBase)world), newPos.up(2)).with(new Property((class_2769)BlockPSDTopTianjinBMT.STYLE.data), (Comparable)((Object)BlockPSDTopTianjinBMT.EnumPSDType.BMT)));
        }
        context.getStack().decrement(1);
        return ActionResult.SUCCESS;
    }

    public boolean isAPG() {
        return this.block.data instanceof BlockFlagAPGTianjin || this.block.data instanceof BlockFlagAPGTianjinBMT || this.block.data instanceof BlockFlagAPGTianjinTRT;
    }

    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        if (this.block.data instanceof BlockPSDAPGDoorBase) {
            tooltip.add(TextHelper.translatable((String)"tooltip.mtr.psd_apg_door", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        } else if (this.block.data instanceof BlockPSDAPGGlassEndBase) {
            tooltip.add(TextHelper.translatable((String)"tooltip.mtr.psd_apg_glass_end", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        } else if (this.block.data instanceof BlockPSDAPGGlassBase) {
            tooltip.add(TextHelper.translatable((String)"tooltip.mtr.psd_apg_glass", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        }
        if (this.block.data instanceof BlockFlagPSDTianjin || this.block.data instanceof BlockFlagAPGTianjinBMT) {
            IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.psd_apg_tianjin", (Object[])new Object[0]));
        }
    }

    @Nonnull
    public String getTranslationKey2() {
        if (this.block.data instanceof BlockFlagPSDTianjinJinjing) {
            return "block.tjmetro.psd_tianjin_jinjing";
        }
        if (this.block.data instanceof BlockFlagPSDTianjin) {
            return "block.tjmetro.psd_tianjin";
        }
        if (this.block.data instanceof BlockFlagPSDTianjinBMT) {
            return "block.tjmetro.psd_tianjin_bmt";
        }
        if (this.block.data instanceof BlockFlagAPGTianjinJinjing) {
            return "block.tjmetro.apg_tianjin_jinjing";
        }
        if (this.block.data instanceof BlockFlagAPGTianjin) {
            return "block.tjmetro.apg_tianjin";
        }
        if (this.block.data instanceof BlockFlagAPGTianjinBMT) {
            return "block.tjmetro.apg_tianjin_bmt";
        }
        return "block.tjmetro.apg_tianjin_trt";
    }
}

