/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.block.BlockAPGDoorTianjinTRT;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockAPGGlassEnd;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderAPGDoorTianjinTRT<T extends BlockPSDAPGDoorBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    protected static final ModelSingleCube MODEL_APG_TOP = new ModelSingleCube(34, 9, 0, 8, 1, 16, 8, 1);
    protected static final ModelAPGDoorBottom MODEL_APG_BOTTOM = new ModelAPGDoorBottom();
    protected static final ModelSingleCube MODEL_APG_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 10, 1, 6, 6, 0);

    public RenderAPGDoorTianjinTRT(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        entity.tick(tickDelta);
        BlockPos blockPos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockAPGDoorTianjinTRT.FACING);
        boolean side = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockAPGDoorTianjinTRT.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockAPGDoorTianjinTRT.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean unlocked = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (BooleanProperty)BlockAPGDoorTianjinTRT.UNLOCKED);
        double open = Math.min(entity.getDoorValue(), 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        if (half) {
            Block sideBlock = world.getBlockState(blockPos.offset(side ? facing.rotateYClockwise() : facing.rotateYCounterclockwise())).getBlock();
            if (sideBlock.data instanceof BlockAPGGlass || sideBlock.data instanceof BlockAPGGlassEnd) {
                if (open > 0.0) {
                    this.tryUpdateLightState(world, blockPos, BlockAPGDoorTianjinTRT.LightProperty.LIGHT_ON);
                } else {
                    this.tryUpdateLightState(world, blockPos, BlockAPGDoorTianjinTRT.LightProperty.LIGHT_OFF);
                }
            } else {
                this.tryUpdateLightState(world, blockPos, BlockAPGDoorTianjinTRT.LightProperty.NO_LIGHT);
            }
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        MainRenderer.scheduleRender((Identifier)new Identifier("tjmetro", String.format("textures/block/apg_door_tianjin_trt_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            (half ? MODEL_APG_TOP : MODEL_APG_BOTTOM).render(graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            graphicsHolderNew.pop();
        });
        if (half && !unlocked) {
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                MODEL_APG_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
    }

    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    protected void tryUpdateLightState(World world, BlockPos blockPos, BlockAPGDoorTianjinTRT.LightProperty lightProperty) {
        if (IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, BlockAPGDoorTianjinTRT.LIGHT) != lightProperty) {
            world.setBlockState(blockPos, world.getBlockState(blockPos).with(new Property((class_2769)BlockAPGDoorTianjinTRT.LIGHT.data), (Comparable)((Object)lightProperty)));
        }
    }

    protected static class ModelSingleCube
    extends EntityModelExtension<EntityAbstractMapping> {
        protected final ModelPartExtension cube = this.createModelPart();

        protected ModelSingleCube(int textureWidth, int textureHeight, int x, int y, int z, int length, int height, int depth) {
            super(textureWidth, textureHeight);
            this.cube.setTextureUVOffset(0, 0).addCuboid((float)(x - 8), (float)(y - 16), (float)(z - 8), length, height, depth, 0.0f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    protected static class ModelAPGDoorBottom
    extends EntityModelExtension<EntityAbstractMapping> {
        protected final ModelPartExtension bone = this.createModelPart();

        protected ModelAPGDoorBottom() {
            super(34, 27);
            this.bone.setTextureUVOffset(0, 0).addCuboid(-8.0f, -16.0f, -7.0f, 16, 16, 1, 0.0f, false);
            this.bone.setTextureUVOffset(0, 17).addCuboid(-8.0f, -6.0f, -8.0f, 16, 6, 1, 0.0f, false);
            ModelPartExtension cube = this.bone.addChild();
            cube.setPivot(0.0f, -6.0f, -8.0f);
            cube.setRotation(-0.7854f, 0.0f, 0.0f);
            cube.setTextureUVOffset(0, 24).addCuboid(-8.0f, -2.0f, 0.0f, 16, 2, 1, 0.0f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

