/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.ItemList;
import forge.ziyue.tjmetro.mod.Registry;
import forge.ziyue.tjmetro.mod.block.base.BlockEntityRenderable;
import forge.ziyue.tjmetro.mod.data.IGuiExtension;
import forge.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;

public class BlockStationNameEntranceTianjin
extends BlockStationNameBase
implements IBlock {
    public static final IntegerProperty STYLE = IntegerProperty.of((String)"style", (int)0, (int)7);
    public final boolean pinyin;
    public final Type type;

    public BlockStationNameEntranceTianjin(boolean pinyin, Type type) {
        this(Blocks.createDefaultBlockSettings((boolean)false, state -> 15).noCollision(), pinyin, type);
    }

    public BlockStationNameEntranceTianjin(BlockSettings blockSettings, boolean pinyin, Type type) {
        super(blockSettings);
        this.pinyin = pinyin;
        this.type = type;
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockPos pos = ctx.getBlockPos();
        Direction side = ctx.getSide();
        Direction facing = side.getOpposite();
        if (side != Direction.UP && side != Direction.DOWN) {
            BlockState leftState = ctx.getWorld().getBlockState(pos.offset(facing.rotateYCounterclockwise()));
            BlockState rightState = ctx.getWorld().getBlockState(pos.offset(facing.rotateYClockwise()));
            int nearbyStyle = leftState.getBlock().data instanceof BlockStationNameEntranceTianjin ? (Integer)IBlock.getStatePropertySafe((BlockState)leftState, (org.mtr.mapping.holder.Property)new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data)) : (rightState.getBlock().data instanceof BlockStationNameEntranceTianjin ? (Integer)IBlock.getStatePropertySafe((BlockState)rightState, (org.mtr.mapping.holder.Property)new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data)) : 0);
            return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data), (Comparable)Integer.valueOf(nearbyStyle));
        }
        return null;
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
            if (item.data == Items.BRUSH.get().data) {
                world.setBlockState(pos, state.cycle(new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data)));
                this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYClockwise(), new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data), 1);
                this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYCounterclockwise(), new org.mtr.mapping.holder.Property((Property)BlockStationNameEntranceTianjin.STYLE.data), 1);
            } else {
                Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(pos));
            }
        }, null, (Item[])new Item[]{Items.BRUSH.get(), ItemList.WRENCH.get()});
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        boolean tall = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)STYLE) % 2 == 1;
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)(tall ? 0.0 : 4.0), (double)0.0, (double)16.0, (double)(tall ? 16.0 : 12.0), (double)1.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.station_name_entrance_tianjin", (Object[])new Object[0]));
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)STYLE);
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(this.pinyin, this.type, blockPos, blockState);
    }

    public static enum Type {
        TRT,
        BMT,
        JINJING;

    }

    public static class BlockEntity
    extends BlockEntityRenderable {
        protected long selectedId = -1L;
        public static final String KEY_SELECTED_ID = "selected_id";

        public BlockEntity(boolean pinyin, Type type, BlockPos pos, BlockState state) {
            super(BlockEntity.getType(pinyin, type), pos, state, 0.0f, 0.00625f);
        }

        public static BlockEntityType<?> getType(boolean pinyin, Type type) {
            switch (type) {
                case TRT: {
                    if (pinyin) {
                        return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN_PINYIN.get();
                    }
                    return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN.get();
                }
                case BMT: {
                    if (pinyin) {
                        return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN_BMT_PINYIN.get();
                    }
                    return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN_BMT.get();
                }
                case JINJING: {
                    if (pinyin) {
                        return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN_JINJING_PINYIN.get();
                    }
                    return BlockEntityTypes.STATION_NAME_ENTRANCE_TIANJIN_JINJING.get();
                }
            }
            return null;
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedId = compoundTag.getLong(KEY_SELECTED_ID);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLong(KEY_SELECTED_ID, this.selectedId);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(long selectedId) {
            Consumer<Direction> setStyle = direction -> {
                BlockPos offsetPos = this.getPos2();
                org.mtr.mapping.holder.BlockEntity blockEntity = this.getWorld2().getBlockEntity(offsetPos);
                while (blockEntity != null && blockEntity.data instanceof BlockEntity) {
                    BlockEntity entity = (BlockEntity)((Object)((Object)blockEntity.data));
                    entity.selectedId = selectedId;
                    entity.markDirty2();
                    offsetPos = offsetPos.offset(direction);
                    blockEntity = this.getWorld2().getBlockEntity(offsetPos);
                }
            };
            setStyle.accept(IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (DirectionProperty)DirectionHelper.FACING).rotateYClockwise());
            setStyle.accept(IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise());
            this.selectedId = selectedId;
            this.markDirty2();
        }

        public long getSelectedId() {
            return this.selectedId;
        }
    }
}

