/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.block.BlockStationNavigator;
import fabric.ziyue.tjmetro.mod.client.DynamicTextureCache;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderStationNavigator<T extends BlockStationNavigator.BlockEntity>
extends BlockEntityRenderer<T>
implements IBlock,
IGui,
IDrawing {
    public RenderStationNavigator(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockStationNavigator)) {
            return;
        }
        BlockStationNavigator block = (BlockStationNavigator)((Object)state.getBlock().data);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)DirectionHelper.FACING);
        boolean arrowLeft = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)BlockStationNavigator.ARROW_LEFT);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), 0.53125 + (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
            graphicsHolderNew.translate((double)((float)block.getXStart() / 16.0f) - (arrowLeft ? 0.51 : 0.49), 0.0, -0.06875000009313226);
        });
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.53125, 0.5);
        graphicsHolder.rotateYDegrees(-facing.asRotation());
        graphicsHolder.rotateZDegrees(180.0f);
        graphicsHolder.translate((double)((float)block.getXStart() / 16.0f) - 0.51, 0.0, -0.06875000009313226);
        if (MinecraftClientData.getInstance().simplifiedRoutes.isEmpty()) {
            return;
        }
        MainRenderer.scheduleRender((Identifier)DynamicTextureCache.instance.getStationNavigator((LongAVLTreeSet)((BlockStationNavigator.BlockEntity)((Object)entity)).getSelectedRoutes(), (boolean)arrowLeft, (int)-16777216, (float)((float)((BlockStationNavigator.BlockEntity)((Object)entity)).length)).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)0.0f, (float)0.0f, (float)((float)entity.length / 2.0f), (float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)GraphicsHolder.getDefaultLight());
            graphicsHolderNew.pop();
        });
        graphicsHolder.pop();
    }
}

