/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.packet;

import fabric.ziyue.tjmetro.mod.block.BlockStationNavigator;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class PacketUpdateStationNavigatorConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final LongAVLTreeSet selectedRoutes;

    public PacketUpdateStationNavigatorConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int selectedIdsLength = packetBufferReceiver.readInt();
        this.selectedRoutes = new LongAVLTreeSet();
        for (int i = 0; i < selectedIdsLength; ++i) {
            this.selectedRoutes.add(packetBufferReceiver.readLong());
        }
    }

    public PacketUpdateStationNavigatorConfig(BlockPos blockPos, LongAVLTreeSet selectedRoutes) {
        this.blockPos = blockPos;
        this.selectedRoutes = selectedRoutes;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.selectedRoutes.size());
        this.selectedRoutes.forEach(arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockStationNavigator.BlockEntity) {
            BlockStationNavigator.BlockEntity entity1 = (BlockStationNavigator.BlockEntity)((Object)entity.data);
            entity1.setData(this.selectedRoutes);
        }
    }
}

