/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.BlockList;
import fabric.ziyue.tjmetro.mod.ItemList;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockFlagAPGTianjinBMT;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockPSDTop;
import org.mtr.mod.block.IBlock;

public class BlockAPGGlassTianjinBMT
extends BlockAPGGlass
implements BlockFlagAPGTianjinBMT {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.of((String)"propagate_property", (int)0, (int)2);
    public static final EnumProperty<EnumDoorType> STYLE = EnumProperty.of((String)"style", EnumDoorType.class);

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        double y = hit.getPos().getYMapped();
        if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)HALF) == IBlock.DoubleBlockHalf.UPPER) {
            return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
                if (item.data == ItemList.WRENCH.get().data) {
                    world.setBlockState(pos, state.cycle(new Property((class_2769)BlockAPGGlassTianjinBMT.STYLE.data)));
                    BiConsumer<Boolean, Direction> setStyle = (bool, direction) -> {
                        EnumDoorType style = (EnumDoorType)IBlock.getStatePropertySafe((World)world, (BlockPos)pos, STYLE);
                        BlockPos offsetPos = pos;
                        while (true) {
                            if (IBlockExtension.isBlock(world.getBlockState(offsetPos), BlockList.APG_DOOR_TIANJIN_BMT_BLOCK.get())) {
                                int id;
                                offsetPos = offsetPos.offset(direction);
                                style = bool.booleanValue() ? EnumDoorType.byId((id = style.asId() - 1) < 0 ? 2 : id % 3) : EnumDoorType.byId((style.asId() + 1) % 3);
                            } else {
                                if (!IBlockExtension.isBlock(world.getBlockState(offsetPos), BlockList.APG_GLASS_TIANJIN_BMT_BLOCK.get())) break;
                                world.setBlockState(offsetPos, world.getBlockState(offsetPos).with(new Property((class_2769)BlockAPGGlassTianjinBMT.STYLE.data), (Comparable)((Object)style)));
                            }
                            offsetPos = offsetPos.offset(direction);
                        }
                    };
                    setStyle.accept(true, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYClockwise());
                    setStyle.accept(false, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYCounterclockwise());
                } else {
                    world.setBlockState(pos, state.cycle(new Property((class_2769)BlockAPGGlassTianjinBMT.ARROW_DIRECTION.data)));
                    this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYClockwise(), new Property((class_2769)BlockAPGGlassTianjinBMT.ARROW_DIRECTION.data), 3);
                    this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYCounterclockwise(), new Property((class_2769)BlockAPGGlassTianjinBMT.ARROW_DIRECTION.data), 3);
                }
            }, null, (Item[])new Item[]{Items.BRUSH.get(), ItemList.WRENCH.get()});
        }
        return super.onUse2(state, world, pos, player, hand, hit);
    }

    protected boolean isAPG() {
        return true;
    }

    @Nonnull
    public Item asItem2() {
        return ItemList.APG_GLASS_TIANJIN_BMT.get();
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)HALF);
        properties.add((HolderBase<?>)SIDE_EXTENDED);
        properties.add((HolderBase<?>)ARROW_DIRECTION);
        properties.add((HolderBase<?>)STYLE);
    }

    public static enum EnumDoorType implements StringIdentifiable
    {
        ROUTE(0, "route"),
        STATION_NAME(1, "station_name"),
        NEXT_STATION(2, "next_station");

        final int id;
        final String name;

        private EnumDoorType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int asId() {
            return this.id;
        }

        public static EnumDoorType byId(int id) {
            switch (id) {
                case 0: {
                    return ROUTE;
                }
                case 1: {
                    return STATION_NAME;
                }
                case 2: {
                    return NEXT_STATION;
                }
            }
            throw new IllegalStateException();
        }

        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static class BlockEntity
    extends BlockPSDTop.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.APG_GLASS_TIANJIN_BMT.get(), pos, state);
        }
    }
}

