/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.block.BlockAPGGlassTianjinTRT;
import fabric.ziyue.tjmetro.mod.client.DynamicTextureCache;
import fabric.ziyue.tjmetro.mod.render.RenderRouteBase;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderAPGGlassTianjinTRT
extends RenderRouteBase<BlockAPGGlassTianjinTRT.BlockEntity> {
    public RenderAPGGlassTianjinTRT(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher, 4.0f, 9.0f, 3.0f, 8.0f, true, 2, BlockAPGGlass.ARROW_DIRECTION);
    }

    @Override
    public void render(BlockAPGGlassTianjinTRT.BlockEntity entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = entity.getPos2();
        BlockState state = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(-facing.asRotation()));
        InitClient.findClosePlatform((BlockPos)blockPos.down(this.platformSearchYOffset), (int)5, platform -> {
            long platformId = platform.getId();
            storedMatrixTransformations.add(graphicsHolderNew -> {
                graphicsHolderNew.translate(0.0, 1.0, 0.0);
                graphicsHolderNew.rotateZDegrees(180.0f);
                graphicsHolderNew.translate(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
            });
            int leftBlocks = this.getTextureNumber(world, blockPos, facing, true);
            int rightBlocks = this.getTextureNumber(world, blockPos, facing, false);
            int color = org.mtr.mod.render.RenderRouteBase.getShadingColor((Direction)facing, (int)-1);
            RenderRouteBase.RenderType renderType = this.getRenderType(world, blockPos.offset(facing.rotateYCounterclockwise(), leftBlocks), state);
            if (renderType != RenderRouteBase.RenderType.NONE && IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                int arrowDirection;
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                Identifier identifier = DynamicTextureCache.instance.getRouteMapTRT((long)platformId, (boolean)false, (boolean)((arrowDirection = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)this.arrowDirectionProperty)) == 2 ? true : false), (float)(width / height), (boolean)this.transparentWhite).identifier;
                MainRenderer.scheduleRender((Identifier)identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)(leftBlocks == 0 ? this.sidePadding : 0.0f), (float)this.topPadding, (float)0.0f, (float)(1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f)), (float)(1.0f - this.bottomPadding), (float)0.0f, (float)(((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)0.0f, (float)((width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)1.0f, (Direction)facing.getOpposite(), (int)color, (int)light);
                    graphicsHolderNew.pop();
                });
            }
        });
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(World world, BlockPos pos, BlockState state) {
        if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)HALF) == IBlock.DoubleBlockHalf.LOWER) {
            return RenderRouteBase.RenderType.NONE;
        }
        return RenderRouteBase.RenderType.ROUTE;
    }

    @Override
    protected void renderAdditional(StoredMatrixTransformations storedMatrixTransformations, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
    }
}

