/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockAPGCorner
extends BlockExtension
implements DirectionHelper {
    public BlockAPGCorner() {
        this(Blocks.createDefaultBlockSettings((boolean)true));
    }

    public BlockAPGCorner(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState state = this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockAPGCorner.FACING.data), (Comparable)ctx.getPlayerFacing().data);
        ctx.getWorld().setBlockState(ctx.getBlockPos().up(), state.with(new Property((net.minecraft.state.Property)IBlock.HALF.data), (Comparable)IBlock.DoubleBlockHalf.UPPER));
        return state.with(new Property((net.minecraft.state.Property)IBlock.HALF.data), (Comparable)IBlock.DoubleBlockHalf.LOWER);
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)IBlock.HALF) == IBlock.DoubleBlockHalf.UPPER) {
            IBlockExtension.breakBlock(world, pos.down(), BlockList.APG_CORNER.get());
        } else {
            IBlockExtension.breakBlock(world, pos.up(), BlockList.APG_CORNER.get());
        }
        super.onBreak2(world, pos, state, player);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)IBlock.HALF);
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        switch ((IBlock.DoubleBlockHalf)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)IBlock.HALF)) {
            case UPPER: {
                return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)9.0, (double)4.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
            }
            case LOWER: {
                return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
            }
        }
        return VoxelShapes.fullCube();
    }
}

