/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.block.BlockRailwaySignWall;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.block.base.IRailwaySign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mod.block.IBlock;

public class BlockRailwaySignWallDouble
extends BlockRailwaySignWall {
    public BlockRailwaySignWallDouble(int length) {
        super(length);
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        boolean isNext;
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        boolean bl = isNext = !IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)EOS) && direction == facing.rotateYClockwise() || IBlockExtension.isBlock(state, BlockList.RAILWAY_SIGN_WALL_DOUBLE_MIDDLE.get()) && direction == facing.rotateYCounterclockwise();
        if (isNext && !(neighborState.getBlock().data instanceof BlockRailwaySignWallDouble)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        for (int i = 1; i < this.getMiddleLength(); ++i) {
            world.setBlockState(pos.offset(facing.rotateYClockwise(), i), BlockList.RAILWAY_SIGN_WALL_DOUBLE_MIDDLE.get().getDefaultState().with(new Property((net.minecraft.state.Property)BlockRailwaySignWallDouble.FACING.data), (Comparable)facing.data).with(new Property((net.minecraft.state.Property)BlockRailwaySignWallDouble.EOS.data), (Comparable)Boolean.valueOf(false)), 3);
        }
        world.setBlockState(pos.offset(facing.rotateYClockwise(), this.getMiddleLength()), BlockList.RAILWAY_SIGN_WALL_DOUBLE_MIDDLE.get().getDefaultState().with(new Property((net.minecraft.state.Property)BlockRailwaySignWallDouble.FACING.data), (Comparable)facing.data).with(new Property((net.minecraft.state.Property)BlockRailwaySignWallDouble.EOS.data), (Comparable)Boolean.valueOf(true)), 3);
        world.updateNeighbors(pos, Blocks.getAirMapped());
        state.updateNeighbors(new WorldAccess((IWorld)world.data), pos, 3);
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.RAILWAY_SIGN_WALL_DOUBLE_MIDDLE.get());
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.railway_sign_wall_double";
    }

    @Override
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == BlockList.RAILWAY_SIGN_WALL_DOUBLE_MIDDLE.get().data) {
            return null;
        }
        return new BlockEntity(this.length, blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        protected final List<LongAVLTreeSet> selectedIds;
        protected final String[][] signIds;
        protected static final String KEY_SELECTED_IDS = "selected_ids";
        protected static final String KEY_SIGN_LENGTH = "sign_length";

        public BlockEntity(int length, BlockPos pos, BlockState state) {
            super(BlockEntity.getType(length), pos, state);
            this.signIds = new String[2][length];
            this.selectedIds = new ArrayList<LongAVLTreeSet>();
            this.selectedIds.add(new LongAVLTreeSet());
            this.selectedIds.add(new LongAVLTreeSet());
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedIds.forEach(LongAVLTreeSet::clear);
            for (int i = 0; i < 2; ++i) {
                Arrays.stream(compoundTag.getLongArray(KEY_SELECTED_IDS + i)).forEach(arg_0 -> ((LongAVLTreeSet)this.selectedIds.get(i)).add(arg_0));
                for (int j = 0; j < this.signIds[i].length; ++j) {
                    String signId = compoundTag.getString(KEY_SIGN_LENGTH + i + j);
                    this.signIds[i][j] = signId.isEmpty() ? null : signId;
                }
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < 2; ++i) {
                compoundTag.putLongArray(KEY_SELECTED_IDS + i, new ArrayList((Collection)this.selectedIds.get(i)));
                for (int j = 0; j < this.signIds[i].length; ++j) {
                    compoundTag.putString(KEY_SIGN_LENGTH + i + j, this.signIds[i][j] == null ? "" : this.signIds[i][j]);
                }
            }
        }

        public void setData(List<LongAVLTreeSet> selectedIds, String[][] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll(selectedIds);
            if (this.signIds[0].length == signTypes[0].length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.markDirty2();
        }

        public List<LongAVLTreeSet> getSelectedIds() {
            return this.selectedIds;
        }

        public String[][] getSignIds() {
            return this.signIds;
        }

        protected static BlockEntityType<?> getType(int length) {
            switch (length) {
                case 4: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_DOUBLE_4.get();
                }
                case 6: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_DOUBLE_6.get();
                }
                case 8: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_DOUBLE_8.get();
                }
                case 10: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_DOUBLE_10.get();
                }
            }
            return null;
        }
    }
}

