/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.BlockList;
import fabric.ziyue.tjmetro.mod.ItemList;
import fabric.ziyue.tjmetro.mod.Registry;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import fabric.ziyue.tjmetro.mod.block.base.IRailwaySign;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import fabric.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.block.IBlock;

public class BlockRouteMapBMT
extends BlockRailwaySignBase {
    public BlockRouteMapBMT() {
        this(Blocks.createDefaultBlockSettings((boolean)true, state -> 10));
    }

    public BlockRouteMapBMT(BlockSettings blockSettings) {
        super(blockSettings, 6, false);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        if (!IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)(this.getMiddleLength() + 2))) {
            return null;
        }
        for (int i = 0; i < this.getMiddleLength() + 2; ++i) {
            if (ctx.getWorld().getBlockState(ctx.getBlockPos().down().offset(facing.rotateYClockwise(), i)).canReplace(ctx)) continue;
            return null;
        }
        return this.getDefaultState2().with(new Property((class_2769)BlockRouteMapBMT.FACING.data), (Comparable)facing.data);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
            BlockPos checkPos;
            BlockPos blockPos = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (EnumProperty)HALF) == IBlock.DoubleBlockHalf.LOWER ? pos.up() : pos;
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            Direction hitSide = hit.getSide();
            if ((hitSide == facing || hitSide == facing.getOpposite()) && (checkPos = this.findEndWithDirection(world, blockPos, hitSide.getOpposite(), false)) != null) {
                if (item.data == Items.BRUSH.get().data) {
                    world.setBlockState(checkPos, world.getBlockState(checkPos).cycle(new Property((class_2769)BlockRouteMapBMT.SIDE.data)));
                } else {
                    Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(checkPos));
                }
            }
        }, null, (Item[])new Item[]{Items.BRUSH.get(), ItemList.WRENCH.get()});
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return IRailwaySign.getStateForNeighborUpdate(state, direction, neighborState, BlockList.ROUTE_MAP_BMT_MIDDLE.get());
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        world.setBlockState(pos.down(), state.getBlock().getDefaultState().with(new Property((class_2769)BlockRouteMapBMT.FACING.data), (Comparable)facing.data).with(new Property((class_2769)BlockRouteMapBMT.HALF.data), (Comparable)IBlock.DoubleBlockHalf.LOWER), 3);
        BlockState middleState = BlockList.ROUTE_MAP_BMT_MIDDLE.get().getDefaultState().with(new Property((class_2769)BlockRouteMapBMT.FACING.data), (Comparable)facing.data);
        for (int i = 1; i <= this.getMiddleLength(); ++i) {
            BlockPos blockPos = pos.offset(facing.rotateYClockwise(), i);
            world.setBlockState(blockPos, middleState.with(new Property((class_2769)BlockRouteMapBMT.HALF.data), (Comparable)IBlock.DoubleBlockHalf.UPPER), 3);
            world.setBlockState(blockPos.down(), middleState.with(new Property((class_2769)BlockRouteMapBMT.HALF.data), (Comparable)IBlock.DoubleBlockHalf.LOWER), 3);
        }
        BlockPos blockPos = pos.offset(facing.rotateYClockwise(), this.getMiddleLength() + 1);
        world.setBlockState(blockPos, state.getBlock().getDefaultState().with(new Property((class_2769)BlockRouteMapBMT.FACING.data), (Comparable)facing.getOpposite().data).with(new Property((class_2769)BlockRouteMapBMT.HALF.data), (Comparable)IBlock.DoubleBlockHalf.UPPER), 3);
        world.setBlockState(blockPos.down(), state.getBlock().getDefaultState().with(new Property((class_2769)BlockRouteMapBMT.FACING.data), (Comparable)facing.getOpposite().data).with(new Property((class_2769)BlockRouteMapBMT.HALF.data), (Comparable)IBlock.DoubleBlockHalf.LOWER), 3);
        world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
        state.updateNeighbors(new WorldAccess((class_1936)world.data), pos, 3);
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos blockPos = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (EnumProperty)HALF) == IBlock.DoubleBlockHalf.LOWER ? pos.up() : pos;
        BlockPos checkPos = this.findEndWithDirection(world, blockPos, facing, true);
        if (checkPos != null) {
            IBlockExtension.breakBlock(world, checkPos);
            IBlockExtension.breakBlock(world, checkPos.down());
        }
        IBlockExtension.breakBlock(world, pos.down());
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        IBlock.DoubleBlockHalf half = (IBlock.DoubleBlockHalf)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)HALF);
        if (this == BlockList.ROUTE_MAP_BMT_MIDDLE.get().data) {
            if (half == IBlock.DoubleBlockHalf.UPPER) {
                return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
            }
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0, (Direction)facing);
        }
        if (half == IBlock.DoubleBlockHalf.UPPER) {
            VoxelShape pole = IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)7.0, (double)4.25, (double)16.0, (double)9.0, (Direction)facing);
            VoxelShape plate = IBlock.getVoxelShapeByDirection((double)4.25, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
            return VoxelShapes.union((VoxelShape)pole, (VoxelShape)plate);
        }
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0, (Direction)facing);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.station_name_plate", (Object[])new Object[0]));
    }

    @Override
    protected int getMiddleLength() {
        return 1;
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.route_map_bmt";
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)SIDE);
        properties.add((HolderBase<?>)HALF);
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.ROUTE_MAP_BMT_MIDDLE.get());
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == BlockList.ROUTE_MAP_BMT_MIDDLE.get().data || IBlock.getStatePropertySafe((BlockState)blockState, (EnumProperty)HALF) == IBlock.DoubleBlockHalf.LOWER) {
            return null;
        }
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockRouteSignBase.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.ROUTE_MAP_BMT.get(), pos, state);
        }
    }
}

