/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.client;

import forge.ziyue.tjmetro.mod.client.DynamicTextureCache;
import java.util.function.Supplier;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;

public class ScrollingText
implements IGui {
    protected float ticksOffset;
    public Supplier<DynamicTextureCache.DynamicResource> imageSupplier;
    protected final double availableWidth;
    protected final double availableHeight;
    protected final int scrollSpeed;
    protected final boolean isFullPixel;
    public static final float EPSILON = 0.03f;

    public ScrollingText(double availableWidth, double availableHeight, int scrollSpeed, boolean isFullPixel) {
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.scrollSpeed = scrollSpeed;
        this.isFullPixel = isFullPixel;
    }

    public void changeImage(Supplier<DynamicTextureCache.DynamicResource> imageSupplier) {
        if (this.imageSupplier != imageSupplier) {
            this.imageSupplier = imageSupplier;
            this.ticksOffset = InitClient.getGameTick();
        }
    }

    public boolean scrollText(GraphicsHolder graphicsHolder, Direction facing) {
        if (this.imageSupplier != null) {
            graphicsHolder.push();
            int pixelScale = this.isFullPixel ? 1 : 4;
            double scale = this.availableHeight / (double)this.imageSupplier.get().height;
            int widthSteps = (int)Math.floor(this.availableWidth / scale / (double)pixelScale);
            int imageSteps = this.imageSupplier.get().width / pixelScale;
            int totalSteps = widthSteps + imageSteps;
            int step = Math.round((InitClient.getGameTick() - this.ticksOffset) * (float)this.scrollSpeed) % totalSteps;
            double width = Math.min(Math.min(this.availableWidth, (double)this.imageSupplier.get().width * scale), Math.min((double)(step * pixelScale) * scale, (double)((totalSteps - step) * pixelScale) * scale));
            float u1 = Math.max((float)(step - widthSteps) / (float)imageSteps, 0.0f);
            float u2 = Math.min((float)step / (float)imageSteps, 1.0f);
            graphicsHolder.createVertexConsumer(RenderLayer.getText((Identifier)this.imageSupplier.get().identifier));
            IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)((float)((double)Math.max(widthSteps - step, 0) * scale * (double)pixelScale)), (float)0.0f, (float)((float)width), (float)((float)this.availableHeight), (float)u1, (float)0.0f, (float)u2, (float)1.0f, (Direction)facing, (int)-1, (int)0xF000F0);
            graphicsHolder.pop();
            return 1.0f - u1 <= 0.03f && 1.0f - u2 <= 0.03f;
        }
        return true;
    }
}

