/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.render;

import forge.ziyue.tjmetro.mod.TianjinMetro;
import forge.ziyue.tjmetro.mod.block.BlockPIDSTianjin;
import forge.ziyue.tjmetro.mod.client.DynamicTextureCache;
import forge.ziyue.tjmetro.mod.client.IDrawingExtension;
import forge.ziyue.tjmetro.mod.render.RenderTimeDisplay;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.ArrivalsCacheClient;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;

public class RenderPIDSTianjin<T extends BlockPIDSTianjin.BlockEntity>
extends BlockEntityRenderer<T>
implements IGui,
Utilities {
    public static final float LEFT_TEXT_X_CENTER = 42.45f;
    public static final float LEFT_TEXT_MAX_WIDTH = 78.55f;
    protected final float maxHeight;
    protected final float maxWidth;
    protected final boolean rotate90;
    protected final float textPadding;

    public RenderPIDSTianjin(BlockEntityRenderer.Argument dispatcher, float maxHeight, int maxWidth, boolean rotate90, float textPadding) {
        super(dispatcher);
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.rotate90 = rotate90;
        this.textPadding = textPadding;
    }

    public final void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = entity.getPos2();
        if (!BlockPIDSTianjin.canStoreData(world, blockPos)) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)DirectionHelper.FACING);
        if (((BlockPIDSTianjin.BlockEntity)((Object)entity)).getPlatformIds().isEmpty()) {
            LongArrayList platformIds = new LongArrayList();
            InitClient.findClosePlatform((BlockPos)entity.getPos2().down(4), (int)5, platform -> platformIds.add(platform.getId()));
            this.getArrivalsAndRender(entity, blockPos, facing, (LongCollection)platformIds);
        } else {
            this.getArrivalsAndRender(entity, blockPos, facing, (LongCollection)((BlockPIDSTianjin.BlockEntity)((Object)entity)).getPlatformIds());
        }
    }

    private void getArrivalsAndRender(T entity, BlockPos blockPos, Direction facing, LongCollection platformIds) {
        ObjectArrayList arrivalResponseList = ArrivalsCacheClient.INSTANCE.requestArrivals(platformIds);
        MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
            this.render(entity, blockPos, facing, (ObjectArrayList<ArrivalResponse>)arrivalResponseList, (GraphicsHolder)graphicsHolder, (Vector3d)offset);
            this.render(entity, blockPos.offset(facing), facing.getOpposite(), (ObjectArrayList<ArrivalResponse>)arrivalResponseList, (GraphicsHolder)graphicsHolder, (Vector3d)offset);
        });
    }

    private void render(T entity, BlockPos blockPos, Direction facing, ObjectArrayList<ArrivalResponse> arrivalResponseList, GraphicsHolder graphicsHolder, Vector3d offset) {
        BlockPIDSTianjin.Advertisement newAd;
        float scale = 320.0f / this.maxHeight * this.textPadding;
        int arrivalIndex = ((BlockPIDSTianjin.BlockEntity)((Object)entity)).getDisplayPage() * 2;
        graphicsHolder.push();
        graphicsHolder.translate((double)blockPos.getX() - offset.getXMapped() + 0.5, (double)blockPos.getY() - offset.getYMapped() + 0.85, (double)blockPos.getZ() - offset.getZMapped() + 0.5);
        graphicsHolder.rotateYDegrees((float)(this.rotate90 ? 90 : 0) - facing.asRotation());
        graphicsHolder.rotateZDegrees(180.0f);
        graphicsHolder.translate(-0.48, 0.0, -0.48);
        graphicsHolder.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        graphicsHolder.rotateXDegrees(22.5f);
        graphicsHolder.translate(0.0, 0.05, 0.0);
        this.renderTexture(graphicsHolder, new Identifier("tjmetro", "textures/block/pids_tianjin.png"), 251.0f, 115.0f, facing);
        graphicsHolder.translate(0.0, 0.0, -0.1);
        this.renderText(graphicsHolder, RenderTimeDisplay.getFormattedTime(entity.getWorld2().getLunarTime()), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 42.45f, 106.5f, this.maxWidth * scale / 16.0f, 0.5f, -1);
        int languageTicks = (int)Math.floor(InitClient.getGameTick()) / 60;
        for (int i = 0; i < 2; ++i) {
            String destinationFormatted;
            String[] destinationSplit;
            ArrivalResponse arrivalResponse = (ArrivalResponse)Utilities.getElement(arrivalResponseList, (int)(arrivalIndex + i));
            if (arrivalResponse == null) continue;
            String[] tempDestinationSplit = arrivalResponse.getDestination().split("\\|");
            if (arrivalResponse.getRouteNumber().isEmpty()) {
                destinationSplit = tempDestinationSplit;
            } else {
                String newDestination;
                String[] tempNumberSplit = arrivalResponse.getRouteNumber().split("\\|");
                int destinationIndex = 0;
                int numberIndex = 0;
                ObjectArrayList newDestinations = new ObjectArrayList();
                while (!newDestinations.contains((Object)(newDestination = String.format("%s %s", tempNumberSplit[numberIndex % tempNumberSplit.length], tempDestinationSplit[destinationIndex % tempDestinationSplit.length])))) {
                    newDestinations.add((Object)newDestination);
                    ++destinationIndex;
                    ++numberIndex;
                }
                destinationSplit = (String[])newDestinations.toArray((Object[])new String[0]);
            }
            int messageCount = destinationSplit.length;
            int languageIndex = languageTicks % messageCount;
            long arrival = (arrivalResponse.getArrival() - ArrivalsCacheClient.INSTANCE.getMillisOffset() - System.currentTimeMillis()) / 1000L;
            String destination = destinationSplit[languageIndex];
            boolean isCjk = IGui.isCjk((String)destination);
            float yOffset = (float)i * 45.0f;
            switch (arrivalResponse.getCircularState()) {
                case CLOCKWISE: {
                    destinationFormatted = (isCjk ? TranslationProvider.GUI_MTR_CLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_CLOCKWISE_VIA).getString(new Object[]{destination});
                    break;
                }
                case ANTICLOCKWISE: {
                    destinationFormatted = (isCjk ? TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA).getString(new Object[]{destination});
                    break;
                }
                default: {
                    String string = destinationFormatted = isCjk ? TextHelper.translatable((String)"gui.tjmetro.bound_for_pids_cjk", (Object[])new Object[]{destination}).getString() : TextHelper.translatable((String)"gui.tjmetro.bound_for_pids", (Object[])new Object[]{destination}).getString();
                }
            }
            this.renderText(graphicsHolder, isCjk ? TextHelper.translatable((String)(i == 0 ? "gui.tjmetro.this_train_cjk" : "gui.tjmetro.next_train_cjk"), (Object[])new Object[0]).getString() : TextHelper.translatable((String)(i == 0 ? "gui.tjmetro.this_train" : "gui.tjmetro.next_train"), (Object[])new Object[0]).getString(), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.TOP, 42.45f, 8.0f + yOffset, 78.55f, 1.5f, -1);
            this.renderText(graphicsHolder, destinationFormatted, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 42.45f, 45.0f + yOffset, 78.55f, 1.3f, -1);
            if (arrival <= 15L) {
                String textKey = (arrival < 0L ? "gui.tjmetro.arrived" : "gui.tjmetro.arriving") + (isCjk ? "_cjk" : "");
                this.renderText(graphicsHolder, TextHelper.translatable((String)textKey, (Object[])new Object[0]).getString(), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.TOP, 42.45f, 21.5f + yOffset, 78.55f, 0.6f, -1052928);
                continue;
            }
            boolean isMinute = arrival > 60L;
            String arrivalTime = String.valueOf(isMinute ? arrival / 60L : arrival);
            String arrivalUnit = TextHelper.translatable((String)((isMinute ? "gui.tjmetro.minute" : "gui.tjmetro.second") + (isCjk ? "_cjk" : "")), (Object[])new Object[0]).getString();
            float arrivalTimeWidth = ((Float)IDrawingExtension.stringWidthWithFont(arrivalTime, 0.4f, 1.0f, false).left()).floatValue();
            float arrivalUnitWidth = ((Float)IDrawingExtension.stringWidthWithFont(arrivalUnit, 1.5f, 1.0f, false).left()).floatValue();
            this.renderText(graphicsHolder, arrivalTime, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 42.45f - (arrivalTimeWidth + arrivalUnitWidth) / 2.0f, 30.0f + yOffset, 78.55f, 0.4f, -1052928);
            this.renderText(graphicsHolder, arrivalUnit, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 42.45f + (arrivalTimeWidth + arrivalUnitWidth) / 2.0f, 30.0f + yOffset, 78.55f, 1.5f, -1);
        }
        if (((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().isEmpty()) {
            graphicsHolder.pop();
            return;
        }
        graphicsHolder.translate(86.7, 3.38, 0.0);
        if (((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex >= ((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().size() || !BlockPIDSTianjin.CATEGORIES.containsKey(((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().getLong(((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex))) {
            TianjinMetro.LOGGER.warn("Invalid advertisement category id: {} at {}. Skipping!", (Object)((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex, (Object)blockPos.toShortString());
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex = (((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex + 1) % ((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().size();
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex = 0;
            if (!BlockPIDSTianjin.CATEGORIES.containsKey(((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().getLong(((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex))) {
                TianjinMetro.LOGGER.error("Invalid advertisement after reset. Clearing!");
                ((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().clear();
                graphicsHolder.pop();
                return;
            }
        }
        if (((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisement != (newAd = (BlockPIDSTianjin.Advertisement)BlockPIDSTianjin.CATEGORIES.get(((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().getLong(((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex)).get(((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex))) {
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisement = newAd;
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).scrollingText.changeImage(() -> DynamicTextureCache.instance.getPlainText("   " + entity.advertisement.getText().getString() + "   ", -15065786, -1));
        }
        this.renderTexture(graphicsHolder, ((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisement.getImage(), 161.0f, 88.3f, facing);
        graphicsHolder.translate(1.5, (double)75.3f, 0.0);
        boolean shouldSwitch = ((BlockPIDSTianjin.BlockEntity)((Object)entity)).scrollingText.scrollText(graphicsHolder, facing);
        if (shouldSwitch) {
            this.nextSlide(entity);
        }
        graphicsHolder.pop();
    }

    protected void nextSlide(T entity) {
        if (((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex + 1 >= BlockPIDSTianjin.CATEGORIES.get(((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().getLong(((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex)).size()) {
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex = (((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex + 1) % ((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().size();
            ((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex = 0;
            return;
        }
        ((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex = (((BlockPIDSTianjin.BlockEntity)((Object)entity)).advertisementIndex + 1) % BlockPIDSTianjin.CATEGORIES.get(((BlockPIDSTianjin.BlockEntity)((Object)entity)).getCategories().getLong(((BlockPIDSTianjin.BlockEntity)((Object)entity)).categoryIndex)).size();
    }

    protected void renderText(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float availableWidth, float scale, int color) {
        graphicsHolder.push();
        IDrawingExtension.drawStringWithFont(graphicsHolder, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, availableWidth, -1.0f, scale, color, color, 1.0f, false, GraphicsHolder.getDefaultLight(), false, null);
        graphicsHolder.pop();
    }

    protected void renderTexture(GraphicsHolder graphicsHolder, Identifier identifier, float width, float height, Direction facing) {
        graphicsHolder.push();
        graphicsHolder.createVertexConsumer(RenderLayer.getText((Identifier)identifier));
        graphicsHolder.drawTextureInWorld(0.0f, height, 0.0f, width, height, 0.0f, width, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, 0xF000F0);
        graphicsHolder.pop();
    }
}

