/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.ItemList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.World;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;

public interface IBlockExtension {
    public static final EnumProperty<BlockThirdProperty> THIRD = EnumProperty.of((String)"third", BlockThirdProperty.class);

    public static void breakBlock(World world, BlockPos pos) {
        if (world.isClient()) {
            return;
        }
        world.setBlockState(pos, Blocks.getAirMapped().getDefaultState());
    }

    public static void breakBlock(World world, BlockPos pos, Block block) {
        if (world.isClient()) {
            return;
        }
        if (IBlockExtension.isBlock(world.getBlockState(pos), block)) {
            world.setBlockState(pos, Blocks.getAirMapped().getDefaultState());
        }
    }

    public static boolean isBlock(BlockState state, Block block) {
        return state.getBlock().data == block.data;
    }

    public static ActionResult checkHoldingWrench(World world, PlayerEntity player, Runnable callback) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> callback.run(), null, (Item[])new Item[]{ItemList.WRENCH.get()});
    }

    public static ActionResult checkHoldingBrushOrWrench(World world, PlayerEntity player, Runnable callback) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> callback.run(), null, (Item[])new Item[]{ItemList.WRENCH.get(), Items.BRUSH.get()});
    }

    public static <T extends Enum<T>> BlockState cycleBlockState(BlockState state, EnumProperty<T> property, Predicate<T> includes) {
        return IBlockExtension.cycleBlockState(state, property, property.getValues().stream().filter(includes).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> BlockState cycleBlockState(BlockState state, EnumProperty<T> property, T ... includes) {
        return IBlockExtension.cycleBlockState(state, property, Arrays.asList(includes));
    }

    public static <T extends Enum<T>> BlockState cycleBlockState(BlockState state, EnumProperty<T> property, List<T> includes) {
        int index = includes.indexOf(IBlock.getStatePropertySafe((BlockState)state, property));
        if (index < 0 || index == includes.size() - 1) {
            index = -1;
        }
        return state.with(new Property((class_2769)property.data), (Comparable)((Object)((Enum)includes.get(index + 1))));
    }

    public static enum BlockThirdProperty implements StringIdentifiable
    {
        LEFT("left"),
        RIGHT("right"),
        BOTH("both");

        final String name;

        private BlockThirdProperty(String name) {
            this.name = name;
        }

        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

