/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.render.RenderAPGDoorTianjinTRT;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockAPGGlassEnd;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderAPGDoorTianjin<T extends BlockPSDAPGDoorBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    private static final RenderAPGDoorTianjinTRT.ModelSingleCube MODEL_APG_TOP = new RenderAPGDoorTianjinTRT.ModelSingleCube(34, 9, 0, 8, 1, 16, 8, 1);
    private static final RenderAPGDoorTianjinTRT.ModelAPGDoorBottom MODEL_APG_BOTTOM = new RenderAPGDoorTianjinTRT.ModelAPGDoorBottom();
    private static final ModelAPGDoorLight MODEL_APG_LIGHT = new ModelAPGDoorLight();
    private static final RenderAPGDoorTianjinTRT.ModelSingleCube MODEL_APG_DOOR_LOCKED = new RenderAPGDoorTianjinTRT.ModelSingleCube(6, 6, 5, 10, 1, 6, 6, 0);

    public RenderAPGDoorTianjin(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        entity.tick(tickDelta);
        BlockPos blockPos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockPSDAPGDoorBase.FACING);
        boolean side = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean unlocked = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (BooleanProperty)BlockPSDAPGDoorBase.UNLOCKED);
        double open = Math.min(entity.getDoorValue(), 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        StoredMatrixTransformations storedMatrixTransformationsLight = storedMatrixTransformations.copy();
        if (half) {
            Block block = world.getBlockState(blockPos.offset(side ? facing.rotateYClockwise() : facing.rotateYCounterclockwise())).getBlock();
            if (block.data instanceof BlockAPGGlass || block.data instanceof BlockAPGGlassEnd) {
                MainRenderer.scheduleRender((Identifier)new Identifier("tjmetro", String.format("textures/block/apg_door_tianjin_light_%s.png", open > 0.0 ? "on" : "off")), (boolean)false, (QueuedRenderLayer)(open > 0.0 ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR), (graphicsHolderNew, offset) -> {
                    storedMatrixTransformationsLight.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? -0.515625 : 0.515625, 0.0, 0.0);
                    graphicsHolderNew.scale(0.5f, 1.0f, 1.0f);
                    MODEL_APG_LIGHT.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
            }
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        MainRenderer.scheduleRender((Identifier)new Identifier("tjmetro", String.format("textures/block/apg_door_tianjin_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            (half ? MODEL_APG_TOP : MODEL_APG_BOTTOM).render(graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            graphicsHolderNew.pop();
        });
        if (half && !unlocked) {
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                MODEL_APG_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
    }

    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    protected static class ModelAPGDoorLight
    extends EntityModelExtension<EntityAbstractMapping> {
        protected final ModelPartExtension bone = this.createModelPart();

        protected ModelAPGDoorLight() {
            super(8, 8);
            this.bone.setTextureUVOffset(0, 4).addCuboid(-0.5f, -9.0f, -7.0f, 1, 1, 3, 0.05f, false);
            ModelPartExtension cube = this.bone.addChild();
            cube.setPivot(0.0f, -9.05f, -4.95f);
            cube.setRotation(0.3927f, 0.0f, 0.0f);
            cube.setTextureUVOffset(0, 0).addCuboid(-0.5f, 0.05f, -3.05f, 1, 1, 3, 0.05f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

