/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mapping.DustParticleEffect;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ParticleEffect;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockHighSpeedRepeater
extends BlockExtension
implements DirectionHelper {
    public static final BooleanProperty LOCKED = BooleanProperty.of((String)"locked");
    public static final BooleanProperty POWERED = BooleanProperty.of((String)"powered");
    public static final IntegerProperty POWER = IntegerProperty.of((String)"power", (int)0, (int)15);

    public BlockHighSpeedRepeater() {
        this(Blocks.createDefaultBlockSettings((boolean)false));
    }

    public BlockHighSpeedRepeater(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return Block.createCuboidShape((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public int getStrongRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return direction == IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING) && IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED) ? 15 : 0;
    }

    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return this.getStrongRedstonePower2(state, world, pos, direction);
    }

    public void neighborUpdate2(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)LOCKED)) {
            world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.LOCKED.data), (Comparable)Boolean.valueOf(this.isLocked(world, pos, state))));
            return;
        }
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos blockPos1 = pos.offset(direction);
        boolean powered = world.getBlockState(blockPos1).getStrongRedstonePower(new BlockView((BlockGetter)world.data), blockPos1, direction) > 0;
        boolean isLocked = this.isLocked(world, pos, state);
        world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.POWERED.data), (Comparable)Boolean.valueOf(powered)).with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.LOCKED.data), (Comparable)Boolean.valueOf(isLocked)));
    }

    protected int getInputLevel(World world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos);
        if (IBlockExtension.isBlock(blockState, org.mtr.mapping.holder.Blocks.getRedstoneBlockMapped())) {
            return 15;
        }
        if (IBlockExtension.isBlock(blockState, org.mtr.mapping.holder.Blocks.getRedstoneWireMapped())) {
            return IBlock.getStatePropertySafe((BlockState)blockState, (IntegerProperty)POWER);
        }
        return world.getBlockState(pos).getStrongRedstonePower(new BlockView((BlockGetter)world.data), pos, dir);
    }

    public boolean emitsRedstonePower2(BlockState state) {
        return true;
    }

    public void onBlockAdded2(BlockState state, World world, BlockPos pos, BlockState oldState, boolean notify) {
        this.updateTarget(world, pos, state);
    }

    public void onStateReplaced2(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved) {
        if (moved || state.isOf(newState.getBlock())) {
            return;
        }
        super.onStateReplaced2(state, world, pos, newState, moved);
        this.updateTarget(world, pos, state);
    }

    protected void updateTarget(World world, BlockPos pos, BlockState state) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos blockPos = pos.offset(direction.getOpposite());
        world.updateNeighbor(blockPos, this.asBlock2(), pos);
        world.updateNeighborsExcept(blockPos, this.asBlock2(), direction);
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getPlayerFacing().getOpposite();
        BlockPos blockPos = ctx.getBlockPos().offset(direction);
        boolean powered = ctx.getWorld().getBlockState(blockPos).getStrongRedstonePower(new BlockView((BlockGetter)ctx.getWorld().data), blockPos, direction) > 0;
        BlockState state = this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.FACING.data), (Comparable)direction.data).with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.POWERED.data), (Comparable)Boolean.valueOf(powered));
        return state.with(new org.mtr.mapping.holder.Property((Property)BlockHighSpeedRepeater.LOCKED.data), (Comparable)Boolean.valueOf(this.isLocked(ctx.getWorld(), ctx.getBlockPos(), state)));
    }

    public boolean isLocked(World world, BlockPos pos, BlockState state) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        Direction direction2 = direction.rotateYClockwise();
        Direction direction3 = direction.rotateYCounterclockwise();
        return Math.max(this.getInputLevel(world, pos.offset(direction2), direction2), this.getInputLevel(world, pos.offset(direction3), direction3)) > 0;
    }

    public void randomDisplayTick2(BlockState state, World world, BlockPos pos, Random random) {
        if (!IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED)) {
            return;
        }
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        double d = (double)pos.getX() + 0.5 + (((java.util.Random)random.data).nextDouble() - 0.5) * 0.2;
        double e = (double)pos.getY() + 0.4 + (((java.util.Random)random.data).nextDouble() - 0.5) * 0.2;
        double f = (double)pos.getZ() + 0.5 + (((java.util.Random)random.data).nextDouble() - 0.5) * 0.2;
        float g = ((java.util.Random)random.data).nextBoolean() ? 7.0f : -5.0f;
        double h = (g /= 16.0f) * (float)direction.getOffsetX();
        double i = g * (float)direction.getOffsetZ();
        world.addParticle(new ParticleEffect((ParticleOptions)DustParticleEffect.BLUE), d + h, e, f + i, 0.0, 0.0, 0.0);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)POWERED);
        properties.add((HolderBase<?>)LOCKED);
    }
}

